% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regularization.R
\docType{class}
\name{N1-class}
\alias{N1-class}
\alias{N1}
\alias{evaluate,N1,TwoStageDesign-method}
\title{Regularize n1}
\usage{
N1(label = NA_character_)

\S4method{evaluate}{N1,TwoStageDesign}(s, design, optimization = FALSE, ...)
}
\arguments{
\item{label}{object label (string)}

\item{s}{\code{\link[=Scores]{Score}} object}

\item{design}{object}

\item{optimization}{logical, if \code{TRUE} uses a relaxation to real
parameters of the underlying design; used for smooth optimization.}

\item{...}{further optional arguments}
}
\value{
an object of class \code{\link{N1}}
}
\description{
\code{N1} is a class that computes the \code{n1} value of a design.
This can be used as a score in \code{\link{minimize}}.
}
\examples{
n1_score <- N1()

evaluate(
   N1(),
   TwoStageDesign(70, 0, 2, rep(60, 6), rep(1.7, 6))
) # 70

}
\seealso{
See \code{\link{AverageN2}} for a regularization of
 the second-stage sample size.
}
