% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy.CM.R
\name{fuzzy.CM}
\alias{fuzzy.CM}
\title{Fuzzy C-Means}
\usage{
fuzzy.CM(X, K, m, max.iteration, threshold, member.init, RandomNumber = 0,
  print.result = 0)
}
\arguments{
\item{X}{dataset (matrix/data frame)}

\item{K}{number of cluster}

\item{m}{fuzzyfier}

\item{max.iteration}{maximum iteration for convergence}

\item{threshold}{convergence criteria}

\item{member.init}{membership object or matrix that will be used for initialized}

\item{RandomNumber}{random number for start initializing}

\item{print.result}{print result (9/1)}
}
\value{
Fuzzy Clustering object
}
\description{
Fuzzy C-Means clustering Algorithm (Bezdek, 1984)
}
\details{
This function perform Fuzzy C-Means algorithm by Bezdek (1984).
Fuzzy C-Means is one of fuzzy clustering methods to clustering dataset
become K cluster. Number of cluster (K) must be greater than 1. To control the overlaping
or fuzziness of clustering, parameter m must be specified.
Maximum iteration and threshold is specific number for convergencing the cluster.
Random Number is number that will be used for seeding to firstly generate fuzzy membership matrix.

Clustering will produce fuzzy membership matrix (U) and fuzzy cluster centroid (V).
The greatest value of membership on data point will determine cluster label.
Centroid or cluster center can be use to interpret the cluster. Both membership and centroid produced by
calculating mathematical distance. Fuzzy C-Means calculate distance with Euclideans norm.
}
\section{Slots}{

\describe{
\item{\code{centroid}}{centroid matrix}

\item{\code{distance}}{distance matrix}

\item{\code{func.obj}}{function objective}

\item{\code{call.func}}{called function}

\item{\code{fuzzyfier}}{fuzzyness parameter}

\item{\code{method.fuzzy}}{method of fuzzy clustering used}

\item{\code{member}}{membership matrix}

\item{\code{hard.label}}{hard.label}
}}
\examples{
fuzzy.CM(iris[,1:4],K=3,m=2,max.iteration=100,threshold=1e-5,RandomNumber=1234)
}
\references{
Balasko, B., Abonyi, J., & Feil, B. (2002). Fuzzy Clustering and Data Analysis Toolbox: For Use with Matlab. Veszprem, Hungary.

Bezdek, J. C., Ehrlich, R., & Full, W. (1984). FCM: The Fuzzy C-Means Clustering Algorithm. Computers and Geosciences Vol 10, 191-203
}

