% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsd.R
\name{tsd}
\alias{tsd}
\title{Create a S3 \code{aedseo_tsd} (time-series data) object from observed data
and corresponding dates.}
\usage{
tsd(observed, time, time_interval = c("day", "week", "month"))
}
\arguments{
\item{observed}{A numeric vector containing the observations.}

\item{time}{A date vector containing the corresponding dates.}

\item{time_interval}{A character vector specifying the time interval.
Choose between "day," "week," or "month."}
}
\value{
A \code{aedseo_tsd} object containing:
\itemize{
\item 'time': The time point for for where the observations is observed.
\item 'observed': The observed value at the time point.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function takes observed data and the corresponding date vector and
converts it into a \code{aedseo_tsd} object, which is a time series
data structure that can be used for time series analysis.
}
\examples{
# Create a `aedseo_tsd` object from daily data
daily_tsd <- tsd(
  observed = c(10, 15, 20, 18),
  time = as.Date(
    c("2023-01-01", "2023-01-02", "2023-01-03", "2023-01-04")
  ),
  time_interval = "day"
)

# Create a `aedseo_tsd` object from weekly data
weekly_tsd <- tsd(
  observed = c(100, 120, 130),
  time = as.Date(
    c("2023-01-01", "2023-01-08", "2023-01-15")
  ),
  time_interval = "week"
)

# Create a `aedseo_tsd` object from monthly data
monthly_tsd <- tsd(
  observed = c(500, 520, 540),
  time = as.Date(
    c("2023-01-01", "2023-02-01", "2023-03-01")
  ),
  time_interval = "month"
)

}
