% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consecutive_growth_warnings.R
\name{consecutive_growth_warnings}
\alias{consecutive_growth_warnings}
\title{Create a tsd_growth_warning object to count consecutive significant observations}
\usage{
consecutive_growth_warnings(onset_output)
}
\arguments{
\item{onset_output}{A \code{tsd_onset} object returned from \code{seasonal_onset()}.}
}
\value{
An object of class \code{tsd_growth_warning}, containing;
A tibble of processed observations, the significant_counter column specifies when a sequence of
significant observation starts and ends. The first number is how many subsequent observations will be significant.
}
\description{
This function calculates the number of consecutive significant ("growth_warning") observations,
grouping them accordingly. The result is stored in an S3 object of class \code{tsd_threshold}.

Uses data from a \code{tsd_onset} object (output from \code{seasonal_onset()}).

\code{seasonal_onset()} has to be run with arguments;
\itemize{
\item season_start
\item season_end
\item only_current_season = FALSE
}
}
\examples{
# Generate simulated data of seasonal waves
sim_data <- generate_seasonal_data(
  years = 5,
  start_date = as.Date("2022-05-26"),
  trend_rate = 1.002,
  noise_overdispersion = 2,
  relative_epidemic_concentration = 3
)

# Estimate seasonal onset
tsd_onset <- seasonal_onset(
  tsd = sim_data,
  family = "quasipoisson",
  season_start = 21,
  season_end = 20,
  only_current_season = FALSE
)

# Get consecutive significant observations
consecutive_growth_warnings(tsd_onset)
}
