% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessdb.R
\docType{data}
\name{am_countries}
\alias{am_countries}
\alias{am_countries_wld}
\title{Dataset of Countries in the Database}
\format{
A data frame with 55 (wld = 195) rows and 9 variables (sorted by Country):
\describe{
  \item{Country}{Short Country Name}
  \item{Country_ISO}{ISO Standardized Country Name}
  \item{ISO2}{ISO 2-Character Country Code}
  \item{ISO3}{ISO 3-Character Country Code}
  \item{ISO3N}{ISO Numeric Country Code}
  \item{IMF}{IMF Numeric Country Code}
  \item{Region}{2-Region Classification (UN except for Sudan)}
  \item{Region_Detailed}{5-Region Classification (Former World Bank)}
  \item{Currency}{Main Official Currency}
}

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 195 rows and 9 columns.
}
\source{
\href{https://CRAN.R-project.org/package=countrycode}{countrycode} R package (with some modification of regional aggregates).
}
\usage{
am_countries

am_countries_wld
}
\description{
\code{am_countries} is a data.frame containing standardized codes of 55 African countries
(including Western Sahara) according to various classifications
and regional aggregations. \code{am_countries_wld} provides the same information for 195
countries, which includes the 193 UN Member States, Western Sahara and Taiwan. The API
generally provides data for all 195 countries, but by default only requests data for Africa.
Note that the API (\code{\link{am_data}}) only supports "ISO3" character codes.
}
\examples{
head(am_countries)
}
\seealso{
\code{\link{am_entities}}, \code{\link{am_sources}}, \code{\link{am_series}}, \code{\link{africamonitor}}
}
\keyword{datasets}
