% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessdb.R
\name{am_series}
\alias{am_series}
\title{Retrieve Series Table}
\usage{
am_series(
  dsid = NULL,
  source.info = TRUE,
  ordered = TRUE,
  return.query = FALSE
)
}
\arguments{
\item{dsid}{character. (Optional) id's of datasources matching the 'DSID' column of the data sources table (retrieved using \code{\link[=am_sources]{am_sources()}}) for which series information is to be returned.}

\item{source.info}{logical. \code{TRUE} returns additional information from the data sources table (the source, the frequency of the data and when it was last updated).}

\item{ordered}{logical. \code{TRUE} returns the series in a fixed order, while \code{FALSE} returns the result in a random order, to the benefit of faster query execution.}

\item{return.query}{logical. \code{TRUE} will not query the database but instead return the constructed SQL query as a character string (for debugging purposes).}
}
\value{
A \code{\link[data.table]{data.table}} with information about the available series in the database.
}
\description{
This function pulls information about the data series available in the database.
}
\details{
The series table gives information about all of the time series in the database. Each series is given a unique code, and
has a label describing the series. Further information recorded are the minimum and maximum time coverage, and (optionally) a separate series source and url.
The default \code{source.info = TRUE} adds the source, the frequency of the data (homogeneous within source), and the date when the source was last updated.
}
\examples{
\donttest{
# By default returns all series with additional information
am_series()

# Raw series table
am_series(source.info = FALSE)

# Only series in the WEO
am_series("IMF_WEO")
}
}
\seealso{
\code{\link{am_countries}}, \code{\link{am_sources}}, \code{\link{am_data}}, \code{\link{africamonitor}}
}
