% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RAgena.R
\docType{class}
\name{Model-class}
\alias{Model-class}
\alias{Model}
\title{BN Model object}
\description{
BN Model object
}
\section{Fields}{

\describe{
\item{\code{id}}{model id}

\item{\code{networks}}{list of networks in the model}

\item{\code{dataSets}}{list of dataSets in the model}

\item{\code{networkLinks}}{list of network links in the model}

\item{\code{settings}}{list of settings of the model}
}}

\section{Methods}{

\describe{
\item{\code{add_network(newNetwork)}}{A method to add a new Network object to the networks field of a Model object.
The input newNetwork is a Network object and it is added to the model if it is
not already in it.}

\item{\code{add_network_link(
  source_network,
  source_node,
  target_network,
  target_node,
  link_type,
  pass_state = NULL
)}}{This is the method to add links to a model between its networks.
These links start from a "source node" in a network and go to a "target node" in another network.
To create the link, the source and target nodes in the networks need to be specified together
with the network they belong to (by the Node and Network ids). See README.md for details.}

\item{\code{change_settings(settings)}}{A method to change model settings. The input parameter settings must be a list with the correctly
named elements, see README.md for example.}

\item{\code{clear_all_observations()}}{A method to clear all observations defined in a model. This function removes all observations
from all datasets (scenarios).}

\item{\code{clear_dataSet_observations(dataSet)}}{A method to clear all observations in a specific dataset (scenario) in the model.}

\item{\code{create_dataSet(id)}}{It is possible to add multiple scenarios to a model. These scenarios are new DataSet
objects added to the dataSets field of a model. Initially these scenarios have no observations
and are only defined by their ids. The scenarios are populated with the enter_observation() function.}

\item{\code{default_settings()}}{A method to reset model settings back to default values.}

\item{\code{enter_observation(
  dataSet = NULL,
  node,
  network,
  value,
  variable_input = FALSE,
  soft_evidence = FALSE
)}}{A method to enter observation to a model. To enter the observation to a specific dataset (scenario), the dataset id
must be given as the input parameter dateSet. If dataSet is left NULL, the entered observation will by default go to
"Scenario 1". This means that if there is no extra datasets created for a model (which by default comes with "Scenario 1"),
any observation entered will be set for this dataset. See README.md for details and examples.}

\item{\code{get_dataSets()}}{A method to list the ids of all existing scenarios in a model.}

\item{\code{get_networks()}}{A method to see ids of all the networks in a model.}

\item{\code{get_results(filename = NULL)}}{A method to generate a .csv file based on the calculation results a Model contains.}

\item{\code{import_results(result_file)}}{A method to import results of a calculated dataSet from a json file. This correct format for
the results json file for this method is the file generated with the local agena.ai developer
API calculation (see README.md for details.}

\item{\code{initialize(
  id = NULL,
  networks,
  from_cmpx = FALSE,
  dataSets = NULL,
  networkLinks = NULL,
  settings = NULL
)}}{Creates a new Model object, a list of networks (at least one) is required.
id and settings are set with defaults unless specified.}

\item{\code{remove_all_network_links()}}{A method to remove all existing network links in a model.}

\item{\code{remove_dataSet(olddataSet)}}{A method to remove an existing scenario from the model. Input parameter olddataSet
is the string which is the id of a dataset (scenario).}

\item{\code{remove_network(oldNetwork)}}{A method to remove an existing Network object from the model.
Note that removing a Node from a network does not automatically remove its possible network links
to other networks in the model. networkLinks field of a Model should be adjusted accordingly if needed.}

\item{\code{remove_network_link(source_network, source_node, target_network, target_node)}}{A method to remove network links, given the ids of the source and target nodes
(and the networks they belong to).}

\item{\code{remove_observation(dataSet = NULL, node, network)}}{A method to remove a specific observation from the model. It requires the id of the node which
has the observation to be removed and the id of the network the node belongs to.}

\item{\code{to_cmpx(filename = NULL)}}{A method to export the Model to a .cmpx file. This method passes on all the information about the model,
its datasets, its networks, their nodes, and model settings to a .cmpx file in the correct format
readable by agena.ai.
If the input parameter filename is not specified, it will use the Model$id for the filename.}

\item{\code{to_json(filename = NULL)}}{A method to export the Model to a .json file. This method passes on all the information about the model,
its datasets, its networks, their nodes, and model settings to a .json file in the correct format
readable by agena.ai.
If the input parameter filename is not specified, it will use the Model$id for the filename.}
}}

