% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkConection.R
\name{check_connectivity}
\alias{check_connectivity}
\title{Check connectivity between trials}
\usage{
check_connectivity(
  data = NULL,
  genotype = "line",
  trial = "Experiment",
  response = NULL,
  all = FALSE,
  return_matrix = FALSE
)
}
\arguments{
\item{data}{A data.frame in a wide format.}

\item{genotype}{A character string indicating the column in data that
contains genotypes.}

\item{trial}{A character string indicating the column in data that contains
trials.}

\item{response}{A character string specifying the trait.}

\item{all}{Whether or not print all the table.}

\item{return_matrix}{A logical value indicating if the user wants to return
a (n_trial x n_trial) matrix with the amount of genotypes shared between each
pair of trial. (\code{FALSE} by default)}
}
\value{
A data.frame with the genotype connectivity. If return_matrix is
\code{TRUE}, it will return a n_trial x n_trial matrix with the amount of
genotypes shared between each pair of trial.
}
\description{
Check connectivity between trials
}
\examples{
library(agridat)
library(agriutilities)
data(besag.met)
dat <- besag.met
head(
  check_connectivity(
    data = dat,
    genotype = "gen",
    trial = "county",
    response = "yield",
    all = TRUE,
    return_matrix = FALSE
  )
)
}
