% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/load.R
\name{Load}
\alias{Load}
\alias{LoadString}
\title{Load an ahp model from file}
\usage{
Load(ahpFile)

LoadString(ahpString)
}
\arguments{
\item{ahpFile}{The full path to the file to be loaded, or a connection.}

\item{ahpString}{A character string to be loaded.}
}
\value{
A \code{\link{data.tree}} containing the model specification.
}
\description{
ahp files are in YAML format, and they are self-contained, fully specified ahp problems.
They contain two sections: \bold{alternatives} and \bold{goal}.
}
\details{
The \bold{alternatives} section contains a list of alternatives, where each alternative
may have a number of attributes.

The \bold{goal} section is a tree of criteria,
each criteria having a \code{name}, a \code{preferences}
attribute, and possible child criteria or alternatives.

To look at a sample file, type, see examples below or type \code{vignette("examples", package = "ahp")}. To learn
the details about the ahp file format, type \code{vignette("file-format", package = "ahp")}.
}
\examples{
ahpFile <- system.file("extdata", "car.ahp", package="ahp")

#look at a sample file
cat(readChar(ahpFile, file.info(ahpFile)$size))

#load the file into R
carAhp <- Load(ahpFile)
}

