% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_label_dataset_metric.R
\name{binary_label_dataset_metric}
\alias{binary_label_dataset_metric}
\title{Binary Label Dataset Metric}
\usage{
binary_label_dataset_metric(data, privileged_groups, unprivileged_groups)
}
\arguments{
\item{data}{A aif360 compatible dataset.}

\item{privileged_groups}{Privileged groups. List containing privileged protected attribute name and value of the privileged protected attribute.}

\item{unprivileged_groups}{Unprivileged groups. List containing unprivileged protected attribute name and value of the unprivileged protected attribute.}
}
\description{
Class for computing metrics on an aif360 compatible dataset with binary labels.
}
\examples{
\donttest{
load_aif360_lib()
# Load the adult dataset
adult_dataset <- adult_dataset()

# Define the groups
privileged_groups <- list("race", 1)
unprivileged_groups <- list("race", 0)

# Metric for Binary Label Dataset
bm <- binary_label_dataset_metric(data = adult_dataset,
                                  privileged_groups = privileged_groups,
                                  unprivileged_groups = unprivileged_groups)

# Difference in mean outcomes between unprivileged and privileged groups
bm$mean_difference()
}
}
\seealso{
\href{https://aif360.readthedocs.io/en/latest/modules/metrics.html#aif360.metrics.BinaryLabelDatasetMetric}{Explore available binary label dataset metrics here}

Available metrics are: base_rate, consistency, disparate_impact, mean_difference, num_negatives, num_positives and statistical_parity_difference.
}
