% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_embedding_model.R
\name{TextEmbeddingModel}
\alias{TextEmbeddingModel}
\title{Text embedding model}
\value{
Objects of class \code{TextEmbeddingModel} transform raw texts into numerical
representations which can be used for downstream tasks. For this aim objects of this class
allow to tokenize raw texts, to encode tokens to sequences of integers, and to decode sequences
of integers back to tokens.
}
\description{
This \link[R6]{R6} class stores a text embedding model which can be
used to tokenize, encode, decode, and embed raw texts. The object provides a
unique interface for different text processing methods.
}
\seealso{
Other Text Embedding: 
\code{\link{EmbeddedText}},
\code{\link{combine_embeddings}()}
}
\concept{Text Embedding}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TextEmbeddingModel-new}{\code{TextEmbeddingModel$new()}}
\item \href{#method-TextEmbeddingModel-load_model}{\code{TextEmbeddingModel$load_model()}}
\item \href{#method-TextEmbeddingModel-save_model}{\code{TextEmbeddingModel$save_model()}}
\item \href{#method-TextEmbeddingModel-encode}{\code{TextEmbeddingModel$encode()}}
\item \href{#method-TextEmbeddingModel-decode}{\code{TextEmbeddingModel$decode()}}
\item \href{#method-TextEmbeddingModel-embed}{\code{TextEmbeddingModel$embed()}}
\item \href{#method-TextEmbeddingModel-set_publication_info}{\code{TextEmbeddingModel$set_publication_info()}}
\item \href{#method-TextEmbeddingModel-get_publication_info}{\code{TextEmbeddingModel$get_publication_info()}}
\item \href{#method-TextEmbeddingModel-set_software_license}{\code{TextEmbeddingModel$set_software_license()}}
\item \href{#method-TextEmbeddingModel-get_software_license}{\code{TextEmbeddingModel$get_software_license()}}
\item \href{#method-TextEmbeddingModel-set_documentation_license}{\code{TextEmbeddingModel$set_documentation_license()}}
\item \href{#method-TextEmbeddingModel-get_documentation_license}{\code{TextEmbeddingModel$get_documentation_license()}}
\item \href{#method-TextEmbeddingModel-set_model_description}{\code{TextEmbeddingModel$set_model_description()}}
\item \href{#method-TextEmbeddingModel-get_model_description}{\code{TextEmbeddingModel$get_model_description()}}
\item \href{#method-TextEmbeddingModel-get_model_info}{\code{TextEmbeddingModel$get_model_info()}}
\item \href{#method-TextEmbeddingModel-get_package_versions}{\code{TextEmbeddingModel$get_package_versions()}}
\item \href{#method-TextEmbeddingModel-get_basic_components}{\code{TextEmbeddingModel$get_basic_components()}}
\item \href{#method-TextEmbeddingModel-get_bow_components}{\code{TextEmbeddingModel$get_bow_components()}}
\item \href{#method-TextEmbeddingModel-get_transformer_components}{\code{TextEmbeddingModel$get_transformer_components()}}
\item \href{#method-TextEmbeddingModel-get_sustainability_data}{\code{TextEmbeddingModel$get_sustainability_data()}}
\item \href{#method-TextEmbeddingModel-clone}{\code{TextEmbeddingModel$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-new"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-new}{}}}
\subsection{Method \code{new()}}{
Method for creating a new text embedding model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$new(
  model_name = NULL,
  model_label = NULL,
  model_version = NULL,
  model_language = NULL,
  method = NULL,
  max_length = 0,
  chunks = 1,
  overlap = 0,
  aggregation = "last",
  model_dir,
  bow_basic_text_rep,
  bow_n_dim = 10,
  bow_n_cluster = 100,
  bow_max_iter = 500,
  bow_max_iter_cluster = 500,
  bow_cr_criterion = 1e-08,
  bow_learning_rate = 1e-08,
  trace = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model_name}}{\code{string} containing the name of the new model.}

\item{\code{model_label}}{\code{string} containing the label/title of the new model.}

\item{\code{model_version}}{\code{string} version of the model.}

\item{\code{model_language}}{\code{string} containing the language which the model
represents (e.g., English).}

\item{\code{method}}{\code{string} determining the kind of embedding model. Currently
the following models are supported:
\code{method="bert"} for Bidirectional Encoder Representations from Transformers (BERT),
\code{method="roberta"} for A Robustly Optimized BERT Pretraining Approach (RoBERTa),
\code{method="longformer"} for Long-Document Transformer,
\code{method="glove"} for
GlobalVector Clusters, and
\code{method="lda"} for topic modeling. See
details for more information.}

\item{\code{max_length}}{\code{int} determining the maximum length of token
sequences used in transformer models. Not relevant for the other methods.}

\item{\code{chunks}}{\code{int} Maximum number of chunks. Only relevant for
transformer models.}

\item{\code{overlap}}{\code{int} determining the number of tokens which should be added
at the beginning of the next chunk. Only relevant for BERT models.}

\item{\code{aggregation}}{\code{string} method for aggregating the text embeddings
created by transformer models. See details for more information.}

\item{\code{model_dir}}{\code{string} path to the directory where the
BERT model is stored.}

\item{\code{bow_basic_text_rep}}{object of class \code{basic_text_rep} created via
the function \link{bow_pp_create_basic_text_rep}. Only relevant for \code{method="glove"}
and \code{method="lda"}.}

\item{\code{bow_n_dim}}{\code{int} Number of dimensions of the GlobalVector or
number of topics for LDA.}

\item{\code{bow_n_cluster}}{\code{int} Number of clusters created on the basis
of GlobalVectors. Parameter is not relevant for \code{method="lda"} and
\code{method="bert"}}

\item{\code{bow_max_iter}}{\code{int} Maximum number of iterations for fitting
GlobalVectors and Topic Models.}

\item{\code{bow_max_iter_cluster}}{\code{int} Maximum number of iterations for
fitting cluster if \code{method="glove"}.}

\item{\code{bow_cr_criterion}}{\code{double} convergence criterion for GlobalVectors.}

\item{\code{bow_learning_rate}}{\code{double} initial learning rate for GlobalVectors.}

\item{\code{trace}}{\code{bool} \code{TRUE} prints information about the progress.
\code{FALSE} does not.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\itemize{
\item{method: }{In the case of \code{method="bert"}, \code{method="roberta"}, and \code{method="longformer"},
a pretrained transformer model
must be supplied via \code{model_dir}. For \code{method="glove"}
and \code{method="lda"} a new model will be created based on the data provided
via \code{bow_basic_text_rep}. The original algorithm for GlobalVectors provides
only word embeddings, not text embeddings. To achieve text embeddings the words
are clustered based on their word embeddings with kmeans.}

\item{aggregation: }{For creating a text embedding with a transformer model, several options
are possible:
\itemize{
\item{last: }{\code{aggregation="last"} uses only the hidden states of the last layer.}
\item{second_to_last: }{\code{aggregation="second_to_last"} uses the hidden states of the second to last layer.}
\item{fourth_to_last: }{\code{aggregation="fourth_to_last"} uses the hidden states of the fourth to last layer.}
\item{all: }{\code{aggregation="all"} uses the mean of the hidden states of all hidden layers.}
\item{last_four: }{\code{aggregation="last_four"} uses the mean of the hidden states of the last four layers.}
}}

}
}

\subsection{Returns}{
Returns an object of class \link{TextEmbeddingModel}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-load_model"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-load_model}{}}}
\subsection{Method \code{load_model()}}{
Method for loading a transformers model into R.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$load_model(model_dir)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model_dir}}{\code{string} containing the path to the relevant
model directory.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Function does not return a value. It is used for loading a saved
transformer model into the R interface.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-save_model"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-save_model}{}}}
\subsection{Method \code{save_model()}}{
Method for saving a transformer model on disk.Relevant
only for transformer models.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$save_model(model_dir)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model_dir}}{\code{string} containing the path to the relevant
model directory.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Function does not return a value. It is used for saving a transformer model
to disk.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-encode"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-encode}{}}}
\subsection{Method \code{encode()}}{
Method for encoding words of raw texts into integers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$encode(
  raw_text,
  token_encodings_only = FALSE,
  trace = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{raw_text}}{\code{vector} containing the raw texts.}

\item{\code{token_encodings_only}}{\code{bool} If \code{TRUE}, only the token
encodings are returned. If \code{FALSE}, the complete encoding is returned
which is important for BERT models.}

\item{\code{trace}}{\code{bool} If \code{TRUE}, information of the progress
is printed. \code{FALSE} if not requested.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{list} containing the integer sequences of the raw texts with
special tokens.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-decode"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-decode}{}}}
\subsection{Method \code{decode()}}{
Method for decoding a sequence of integers into tokens
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$decode(int_seqence)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{int_seqence}}{\code{list} containing the integer sequences which
should be transformed to tokens or a single integer sequence as \code{vector}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{list} of token sequences
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-embed"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-embed}{}}}
\subsection{Method \code{embed()}}{
Method for creating text embeddings from raw texts


In the case of using a GPU and running out of memory reduce the
batch size or restart R and switch to use cpu only via \link{set_config_cpu_only}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$embed(
  raw_text = NULL,
  doc_id = NULL,
  batch_size = 8,
  trace = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{raw_text}}{\code{vector} containing the raw texts.}

\item{\code{doc_id}}{\code{vector} containing the corresponding IDs for every text.}

\item{\code{batch_size}}{\code{int} determining the maximal size of every batch.}

\item{\code{trace}}{\code{bool} \code{TRUE}, if information about the progression
should be printed on console.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Method returns a \link[R6]{R6} object of class \link{EmbeddedText}. This object
contains the embeddings as a \code{data.frame} and information about the
model creating the embeddings.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-set_publication_info"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-set_publication_info}{}}}
\subsection{Method \code{set_publication_info()}}{
Method for setting the bibliographic information of the model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$set_publication_info(type, authors, citation, url = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{\code{string} Type of information which should be changed/added.
\code{type="developer"}, and \code{type="modifier"} are possible.}

\item{\code{authors}}{List of people.}

\item{\code{citation}}{\code{string} Citation in free text.}

\item{\code{url}}{\code{string} Corresponding URL if applicable.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Function does not return a value. It is used to set the private
members for publication information of the model.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-get_publication_info"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-get_publication_info}{}}}
\subsection{Method \code{get_publication_info()}}{
Method for getting the bibliographic information of the model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$get_publication_info()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{list} of bibliographic information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-set_software_license"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-set_software_license}{}}}
\subsection{Method \code{set_software_license()}}{
Method for setting the license of the model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$set_software_license(license = "GPL-3")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{license}}{\code{string} containing the abbreviation of the license or
the license text.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Function does not return a value. It is used for setting the private
member for the software license of the model.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-get_software_license"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-get_software_license}{}}}
\subsection{Method \code{get_software_license()}}{
Method for requesting the license of the model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$get_software_license()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{string} License of the model
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-set_documentation_license"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-set_documentation_license}{}}}
\subsection{Method \code{set_documentation_license()}}{
Method for setting the license of models' documentation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$set_documentation_license(license = "CC BY-SA")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{license}}{\code{string} containing the abbreviation of the license or
the license text.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Function does not return a value. It is used to set the private member for the
documentation license of the model.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-get_documentation_license"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-get_documentation_license}{}}}
\subsection{Method \code{get_documentation_license()}}{
Method for getting the license of the models' documentation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$get_documentation_license()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{license}}{\code{string} containing the abbreviation of the license or
the license text.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-set_model_description"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-set_model_description}{}}}
\subsection{Method \code{set_model_description()}}{
Method for setting a description of the model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$set_model_description(
  eng = NULL,
  native = NULL,
  abstract_eng = NULL,
  abstract_native = NULL,
  keywords_eng = NULL,
  keywords_native = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{eng}}{\code{string} A text describing the training of the classifier,
its theoretical and empirical background, and the different output labels
in English.}

\item{\code{native}}{\code{string} A text describing the training of the classifier,
its theoretical and empirical background, and the different output labels
in the native language of the model.}

\item{\code{abstract_eng}}{\code{string} A text providing a summary of the description
in English.}

\item{\code{abstract_native}}{\code{string} A text providing a summary of the description
in the native language of the classifier.}

\item{\code{keywords_eng}}{\code{vector} of keywords in English.}

\item{\code{keywords_native}}{\code{vector} of keywords in the native language of the classifier.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Function does not return a value. It is used to set the private members for the
description of the model.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-get_model_description"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-get_model_description}{}}}
\subsection{Method \code{get_model_description()}}{
Method for requesting the model description.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$get_model_description()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{list} with the description of the model in English
and the native language.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-get_model_info"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-get_model_info}{}}}
\subsection{Method \code{get_model_info()}}{
Method for requesting the model information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$get_model_info()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{list} of all relevant model information
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-get_package_versions"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-get_package_versions}{}}}
\subsection{Method \code{get_package_versions()}}{
Method for requesting a summary of the R and python packages'
versions used for creating the classifier.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$get_package_versions()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns a \code{list} containing the versions of the relevant
R and python packages.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-get_basic_components"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-get_basic_components}{}}}
\subsection{Method \code{get_basic_components()}}{
Method for requesting the part of interface's configuration that is
necessary for all models.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$get_basic_components()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns a \code{list}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-get_bow_components"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-get_bow_components}{}}}
\subsection{Method \code{get_bow_components()}}{
Method for requesting the part of interface's configuration that is
necessary bag-of-words models.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$get_bow_components()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns a \code{list}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-get_transformer_components"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-get_transformer_components}{}}}
\subsection{Method \code{get_transformer_components()}}{
Method for requesting the part of interface's configuration that is
necessary for transformer models.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$get_transformer_components()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns a \code{list}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-get_sustainability_data"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-get_sustainability_data}{}}}
\subsection{Method \code{get_sustainability_data()}}{
Method for requesting a log of tracked energy consumption
during training and an estimate of the resulting CO2 equivalents in kg.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$get_sustainability_data()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns a \code{matrix} containing the tracked energy consumption,
CO2 equivalents in kg, information on the tracker used, and technical
information on the training infrastructure for every training run.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextEmbeddingModel-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TextEmbeddingModel-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextEmbeddingModel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
