% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ale-package.R
\docType{package}
\name{ale-package}
\alias{ale-package}
\title{Interpretable Machine Learning and Statistical Inference with Accumulated Local Effects (ALE)}
\description{
Accumulated Local Effects (ALE) were initially developed as a model-agnostic
approach for global explanations of the results of black-box machine learning
algorithms. ALE has a key advantage over other approaches like partial
dependency plots (PDP) and SHapley Additive exPlanations (SHAP): its values
represent a clean functional decomposition of the model. As such, ALE values
are not affected by the presence or absence of interactions among variables
in a mode. Moreover, its computation is relatively rapid. This package
rewrites the original code from the \href{https://CRAN.r-project.org/package=ALEPlot}{\code{{ALEPlot}} package}
for calculating ALE data
and it completely reimplements the plotting of ALE values. It also extends
the original ALE concept to add bootstrap-based confidence intervals and
ALE-based statistics that can be used for statistical inference.
For more details, see Okoli, Chitu. 2023. “Statistical Inference Using
Machine Learning and Classical Techniques Based on Accumulated Local Effects (ALE).”
arXiv. \url{https://arxiv.org/abs/2310.09877}.
}
\references{
Okoli, Chitu. 2023.
“Statistical Inference Using Machine Learning and Classical Techniques Based
on Accumulated Local Effects (ALE).” arXiv. \url{https://arxiv.org/abs/2310.09877}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/tripartio/ale}
  \item \url{https://tripartio.github.io/ale/}
  \item Report bugs at \url{https://github.com/tripartio/ale/issues}
}

}
\author{
Chitu Okoli \email{Chitu.Okoli@skema.edu}
}
\keyword{internal}
