% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accum.R
\name{accum}
\alias{accum}
\title{Split a dataframe column with binomial name into genus and species columns.
Plots change in species richness over time, generates species accumulation curve, and
compares SAC against simulated idealized curve assuming all unique taxa have equal probability
of being sampled at any point in the time series. (author Dietmar Straile)}
\usage{
accum(b_data, phyto_name = "phyto_name", column = NA, n = 100,
  save.pdf = FALSE, lakename = "", datename = "date_dd_mm_yy",
  dateformat = "\%d-\%m-\%y")
}
\arguments{
\item{b_data}{Name of data.frame object}

\item{phyto_name}{Character string: field containing phytoplankton id (species, genus, etc.)}

\item{column}{column name or number for field containing abundance (biomass,biovol, etc.).
Can be NA if the dataset only contains a species list for each sampling date.}

\item{n}{number of simulations for randomized ideal species accumulation curve}

\item{save.pdf}{TRUE/FALSE- should plots be displayed or saved to a pdf?}

\item{lakename}{optional character string for adding lake name to pdf output}

\item{datename}{character string name of b_data field containing date}

\item{dateformat}{character string: posix format for datename column}
}
\value{
a two panel plot with trends in richness on top, and cumulative richness vs. simulated
        accumulation curve on bottom
}
\description{
Split a dataframe column with binomial name into genus and species columns.
Plots change in species richness over time, generates species accumulation curve, and
compares SAC against simulated idealized curve assuming all unique taxa have equal probability
of being sampled at any point in the time series. (author Dietmar Straile)
}
\examples{
data(lakegeneva)
#example dataset with 50 rows
head(lakegeneva)

accum(b_data=lakegeneva,column='biovol_um3_ml',n=10,save.pdf=FALSE)
}
