% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Tmaker}
\alias{Tmaker}
\title{Create the sufficient statistics calculating matrix for approval data}
\usage{
Tmaker(m, k, d)
}
\arguments{
\item{m}{the number of objects}

\item{k}{the number of objects selected}

\item{d}{the order-effect for the desired matrix (0 to k)}
}
\value{
...
}
\description{
Create the sufficient statistics calculating matrix for approval data
}
\examples{
Tmaker(4, 2, 0) # m
Tmaker(4, 2, 1) # generates how many of each
Tmaker(4, 2, 2) # gives data (order = subsets(1:4, 2))

Tmaker(5, 2, 0)
Tmaker(5, 2, 1)
Tmaker(5, 2, 2)

Tmaker(4, 3, 0) #
Tmaker(4, 3, 1) # subsets(1:4, 3), 1 is in 1, 2, and 3
Tmaker(4, 3, 2) # subsets(1:4, 2)
Tmaker(4, 3, 3)












data(cookie)


## voting statistics at different levels
############################################################

# projection onto V0: the number of people in survey
effectsOnV0 <- Tmaker(6, 3, 0) \%*\% cookie$freq
colnames(effectsOnV0) <- "Total Votes"
effectsOnV0 # = sum(cookie$freq)


# projection onto V1: the number of people voting for each cookie
effectsOnV1 <- Tmaker(6, 3, 1) \%*\% cookie$freq
row.names(effectsOnV1) <- cookie$cookies
colnames(effectsOnV1) <- "Total Votes"
effectsOnV1


# projection onto V2: the number of people voting for each cookie-pair
effectsOnV2 <- Tmaker(6, 3, 2) \%*\% cookie$freq
row.names(effectsOnV2) <- sapply(subsets(cookie$cookies, 2), paste, collapse = ", ")
colnames(effectsOnV2) <- "Total Votes"
effectsOnV2


# projection onto V3: the number of people voting for each cookie-triple
effectsOnV3 <- Tmaker(6, 3, 3) \%*\% cookie$freq
row.names(effectsOnV3) <- sapply(subsets(cookie$cookies, 3), paste, collapse = ", ")
colnames(effectsOnV3) <- "Total Votes"
effectsOnV3 # = t(t(cookie$freq)) = the (freq) data
}
\seealso{
\code{\link{Emaker}}, \code{\link{Amaker}}, \code{\link{Mmaker}}, \code{\link{Pmaker}}, \code{\link{Smaker}}
}

