% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/signal.R
\docType{methods}
\name{signal_drift}
\alias{signal_drift}
\alias{signal_drift-method}
\alias{signal_drift,numeric,numeric,numeric-method}
\alias{signal_drift,ANY,missing,ANY-method}
\title{Drift Intensities}
\usage{
signal_drift(x, y, lag, ...)

\S4method{signal_drift}{numeric,numeric,numeric}(x, y, lag)

\S4method{signal_drift}{ANY,missing,ANY}(x, lag, subtract = FALSE)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{lag}{A \code{\link{numeric}} vector specifying the offset or any object that can
be interpreted in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}})}

\item{...}{Currently not used.}

\item{subtract}{A \code{\link{logical}} scalar: should \code{lag} be subtracted to \code{y}?}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Drift Intensities
}
\examples{
## gamma-ray spectrometry
data("BEGe")

## Subset from 2.75 to 200 keV
BEGe <- signal_select(BEGe, from = 3, to = 200)

## Drift
BEGe_plus <- signal_drift(BEGe, lag = 250)
BEGe_minus <- signal_drift(BEGe, lag = 250, subtract = TRUE)

plot(BEGe, type = "l", xlab = "Energy (keV)", ylab = "Count")
lines(BEGe_plus, type = "l", col = "red")
lines(BEGe_minus, type = "l", col = "green")
}
\seealso{
Other signal processing methods: 
\code{\link{signal_bind}()},
\code{\link{signal_correct}()},
\code{\link{signal_mean}()},
\code{\link{signal_shift}()},
\code{\link{subset}()}
}
\author{
N. Frerebeau
}
\concept{signal processing methods}
