% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrule.R
\name{rrule}
\alias{rrule}
\alias{daily}
\alias{weekly}
\alias{monthly}
\alias{yearly}
\title{Create a recurrence rule}
\usage{
daily(since = "1900-01-01", until = "2100-01-01")

weekly(since = "1900-01-01", until = "2100-01-01")

monthly(since = "1900-01-01", until = "2100-01-01")

yearly(since = "1900-01-01", until = "2100-01-01")
}
\arguments{
\item{since}{\verb{[Date(1)]}

The lower bound on the event set. Depending on the final
recurrence rule, pieces of information from this anchor date might be used
to generate a complete recurrence rule.}

\item{until}{\verb{[Date(1)]}

The upper bound on the event set.}
}
\value{
A new empty rrule.
}
\description{
These functions allow you to create a recurrence rule with a specified
frequency. They are the base elements for all recurrence rules. To add
to them, use one of the \verb{recur_*()} functions.
\itemize{
\item \code{daily()} Recur on a daily frequency.
\item \code{weekly()} Recur on a weekly frequency.
\item \code{monthly()} Recur on a monthly frequency.
\item \code{yearly()} Recur on a yearly frequency.
}
}
\details{
By default, \code{since == "1900-01-01"} and \code{until == "2100-01-01"}, which should
capture most use cases well while still being performant. You may need to
adjust these dates if you want events outside this range.

In terms of speed, it is generally more efficient if you adjust the \code{since}
and \code{until} date to be closer to the first date in the sequence of dates
that you are working with. For example, if you are working with dates in the
range of 2019 and forward, adjust the \code{since} date to be \code{2019-01-01} for a
significant speed boost.

As the anchor date, events are often calculated \emph{relative to} this
date. As an example, a rule of "on Monday, every other week" would use
the \code{since} date to find the first Monday to start the recurrence from.

There is no \code{quarterly()} recurrence frequency, but this can be accomplished
with \code{monthly() \%>\% recur_on_interval(3)}. The month to start the quarterly
interval from will be pulled from the \code{since} date inside \code{monthly()}. The
default will use a quarterly rule starting in January since the default
\code{since} date is \code{1900-01-01}. See the examples.
}
\examples{
rrule <- monthly() \%>\% recur_on_mday(25)

alma_search("1970-01-01", "1971-01-01", rrule)

# Notice that dates before 1900-01-01 are never generated with the defaults!
alma_search("1899-01-01", "1901-01-01", rrule)

# Adjust the `since` date to get access to these dates
rrule_pre_1900 <- monthly(since = "1850-01-01") \%>\% recur_on_mday(25)
alma_search("1899-01-01", "1901-01-01", rrule_pre_1900)

# A quarterly recurrence rule can be built from
# `monthly()` and `recur_on_interval()`
on_first_of_the_quarter <- monthly() \%>\%
  recur_on_interval(3) \%>\%
  recur_on_mday(1)

alma_search("1999-01-01", "2000-04-01", on_first_of_the_quarter)

# Alter the starting quarter by altering the `since` date
on_first_of_the_quarter_starting_in_feb <- monthly(since = "1998-02-01") \%>\%
  recur_on_interval(3) \%>\%
  recur_on_mday(1)

alma_search(
  "1999-01-01",
  "2000-04-01",
  on_first_of_the_quarter_starting_in_feb
)

}
