% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_aqs}
\alias{process_aqs}
\title{Process U.S. EPA AQS daily CSV data}
\usage{
process_aqs(
  path = NULL,
  date = c("2018-01-01", "2022-12-31"),
  mode = c("date-location", "available-data", "location"),
  data_field = "Arithmetic.Mean",
  return_format = c("terra", "sf", "data.table"),
  extent = NULL,
  ...
)
}
\arguments{
\item{path}{character(1). Directory path to daily measurement data.}

\item{date}{character(2). Start and end date.
Should be in \code{"YYYY-MM-DD"} format and sorted.}

\item{mode}{character(1). One of
\itemize{
\item "date-location" (all dates * all locations)
\item "available-data" (date-location pairs with available data)
\item "location" (unique locations).
}}

\item{data_field}{character(1). Data field to extract.}

\item{return_format}{character(1). \code{"terra"} or \code{"sf"} or \code{"data.table"}.}

\item{extent}{numeric(4). Spatial extent of the resulting object.
The order should be \code{c(xmin, xmax, ymin, ymax)}.
The coordinate system should be WGS84 (EPSG:4326).}

\item{...}{Placeholders.}
}
\value{
a SpatVector, sf, or data.table object depending on the \code{return_format}
}
\description{
The \code{process_aqs()} function cleans and imports raw air quality
monitoring sites from pre-generated daily CSV files, returning a single
\code{SpatVector} or \code{sf} object.
\code{date} is used to filter the raw data read from csv files.
Filtered rows are then processed according to \code{mode} argument.
Some sites report multiple measurements per day with and without
\href{https://www.epa.gov/sites/default/files/2016-10/documents/exceptional_events.pdf}{exceptional events}
the internal procedure of this function keeps "Included" if there
are multiple event types per site-time.
}
\note{
Choose \code{date} and \code{mode} values with caution.
The function may return a massive data.table depending on the time range,
resulting in a long processing time or even a crash if data is too large
for your computing environment to process.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
aqs <- process_aqs(
  path = "./data/aqs_daily_example.csv",
  date = c("2022-12-01", "2023-01-31"),
  mode = "full",
  return_format = "terra"
)
}
}
\seealso{
\itemize{
\item \code{\link[=download_aqs]{download_aqs()}}
\item \href{https://aqs.epa.gov/aqsweb/documents/codetables/parameters.csv}{EPA, n.d., \emph{AQS Parameter Codes}}
}
}
