% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download_data}
\alias{download_data}
\title{Download raw data wrapper function}
\usage{
download_data(
  dataset_name = c("aqs", "ecoregion", "ecoregions", "geos", "gmted", "koppen",
    "koppengeiger", "merra2", "merra", "modis", "narr", "nlcd", "noaa", "sedac_groads",
    "sedac_population", "groads", "population", "hms", "smoke", "tri", "nei", "gridmet",
    "terraclimate", "huc", "cropscape", "cdl", "prism"),
  directory_to_save = NULL,
  acknowledgement = FALSE,
  ...
)
}
\arguments{
\item{dataset_name}{character(1). Dataset to download.}

\item{directory_to_save}{character(1). Directory to save / unzip
(if zip files are downloaded) data.}

\item{acknowledgement}{logical(1). By setting \code{TRUE} the
user acknowledges that the data downloaded using this function may be very
large and use lots of machine storage and memory.}

\item{...}{Arguments passed to each download function.}
}
\value{
NULL; Data files will be downloaded and stored in respective
sub-directories within \code{directory_to_save}. File format and
sub-directory names depend on data source and dataset of interest.
}
\description{
The \code{download_data()} function accesses and downloads atmospheric, meteorological, and environmental data from various open-access data sources.
}
\note{
\itemize{
\item All download function names are in \code{download_*} formats
}
}
\examples{
download_data(
  dataset_name = "narr",
  variables = "weasd",
  year = c(2023, 2023),
  directory_to_save = tempdir(),
  acknowledgement = TRUE,
  download = FALSE, # NOTE: download skipped for examples,
  remove_command = TRUE
)
}
\seealso{
For details of each download function per dataset,
Please refer to:
\itemize{
\item \code{\link{download_aqs}}: \code{"aqs"}, \code{"AQS"}
\item \code{\link{download_ecoregion}}: \code{"ecoregions"}, \code{"ecoregion"}
\item \code{\link{download_geos}}: \code{"geos"}
\item \code{\link{download_gmted}}: \code{"gmted"}, \code{"GMTED"}
\item \code{\link{download_koppen_geiger}}: \code{"koppen"}, \code{"koppengeiger"}
\item \code{\link{download_merra2}}: "merra2", \code{"merra"}, \code{"MERRA"}, \code{"MERRA2"}
\item \code{\link{download_narr}}: \code{"narr"}
\item \code{\link{download_nlcd}}: \code{"nlcd"}, \code{"NLCD"}
\item \code{\link{download_hms}}: \code{"noaa"}, \code{"smoke"}, \code{"hms"}
\item \code{\link{download_sedac_groads}}: \code{"sedac_groads"}, \code{"groads"}
\item \code{\link{download_sedac_population}}: \code{"sedac_population"},
\code{"population"}
\item \code{\link{download_modis}}: \code{"modis"}, \code{"MODIS"}
\item \code{\link{download_tri}}: \code{"tri"}, \code{"TRI"}
\item \code{\link{download_nei}}: \code{"nei"}, \code{"NEI"}
\item \code{\link{download_gridmet}}: \code{"gridMET"}, \code{"gridmet"}
\item \code{\link{download_terraclimate}}: \code{"TerraClimate"}, \code{"terraclimate"}
\item \code{\link{download_huc}}: \code{"huc"}
\item \code{\link{download_cropscape}}: \code{"cropscape"}, \code{"cdl"}
\item \code{\link{download_prism}}: \code{"prism"}
}
}
\author{
Insang Song
}
