% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAdmin.R
\name{getAdmin.individual}
\alias{getAdmin.individual}
\title{Get an individual tibble of Subordinate Administrative Regions from location}
\usage{
getAdmin.individual(
  keywords,
  key = NULL,
  subdistrict = NULL,
  page = NULL,
  offset = NULL,
  extensions = NULL,
  filter = NULL,
  callback = NULL,
  output = NULL,
  to_table = TRUE
)
}
\arguments{
\item{keywords}{Required.\cr
Search keywords. \cr
Rules: Country/Region, Province/State, City, County/District, Town, Country, Road, Number, Room, Building.}

\item{key}{Optional.\cr
Amap Key. \cr
Applied from 'AutoNavi' Map API official website\url{https://lbs.amap.com/dev/}}

\item{subdistrict}{Optional.\cr
Subordinate Administrative Level.\cr
Display level of subordinate administrative regions. Available value: 0,1,2,3.\cr
`0` do not return subordinate administrative regions.\cr
`1` return first one subordinate administrative regions.\cr
`2` return first two subordinate administrative regions.\cr
`3` return first three subordinate administrative regions.}

\item{page}{Optional.\cr
Which page to return.\cr
Each time the outmost layer will return a maximum of 20 records. If the limit is exceeded, please request the next page of records with the page argument.}

\item{offset}{Optional.\cr
Maximum records per page.\cr
Maximum value is 20.}

\item{extensions}{Optional.\cr
Return results controller.\cr
`base`: does not return the coordinates of the administrative district boundary.\cr
`all`: returns only the boundary value of the current query district, not the boundary value of the child node.}

\item{filter}{Optional.\cr
Filter administrative regions.\cr
Filtering by designated administrative divisions, which returns information only for the province/municipality.\cr
It is strongly recommended to fill in this parameter in order to ensure the correct records.}

\item{callback}{Optional.\cr
Callback Function. \cr
The value of callback is the customized function. Only available with JSON output.
If you don't understand, it means you don't need it, just like me.}

\item{output}{Optional.\cr
 Output Data Structure. \cr
Support JSON and XML. The default value is JSON.}

\item{to_table}{Optional.\cr
Transform response content to tibble.\cr}
}
\value{
Returns a JSON or XML of results containing detailed subordinate administrative region information. See \url{https://lbs.amap.com/api/webservice/guide/api/district} for more information.
}
\description{
Get an individual tibble of Subordinate Administrative Regions from location
}
