% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLocation.R
\name{extractLocation}
\alias{extractLocation}
\title{Extract location from coordinate request}
\usage{
extractLocation(res)
}
\arguments{
\item{res}{Required.\cr
Response from getLocation.}
}
\value{
Returns a data.table which extracts detailed location information from results of getLocation. See \url{https://lbs.amap.com/api/webservice/guide/api/georegeo} for more information.
}
\description{
Extract location from coordinate request
}
\examples{
\dontrun{
library(dplyr)
library(amapGeocode)

# Before the `getLocation()` is executed,
# the token should be set by `option(amap_key = 'key')`
# or set by key argument in `getLocation()`
# Get reverse-geocode as a XML
getLocation(104.043284, 30.666864, output = 'XML') \%>\%
   # extract reverse-geocode regions as a table
   extractLocation()
}

}
\seealso{
\code{\link{getLocation}}
}
