% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amber.case-reports.R
\name{amber.case_reports}
\alias{amber.case_reports}
\title{Get the case report records}
\usage{
amber.case_reports(
  amber,
  study = NULL,
  form = NULL,
  caseReportForm = NULL,
  from = NULL,
  to = NULL,
  pId = NULL,
  query = list(),
  skip = 0,
  limit = 100,
  df = TRUE
)
}
\arguments{
\item{amber}{An Amber object}

\item{study}{Study identifier (name or id), optional.}

\item{form}{Form identifier (name or id), optional.}

\item{caseReportForm}{Case report form identifier (name or id), optional.}

\item{from}{From date (included), optional}

\item{to}{To date (included), optional}

\item{pId}{Patient/participant identifier}

\item{query}{The search query}

\item{skip}{Number of items to skip}

\item{limit}{Max number of items}

\item{df}{Return a data.frame (default is TRUE)}
}
\value{
A data.frame (or a named list of raw results when 'df' is FALSE)
}
\description{
Get the case report records of one or several form(s).
}
\examples{
\dontrun{
a <- amber.login("https://amber-demo.obiba.org")

# Find all case reports
amber.case_reports(a)

# Find all case reports in a range of time
amber.case_reports(a, from = "2022-01-12 00:00", to = "2022-02-13")

# Find all case reports for a specific participant/patient identifier
amber.case_reports(a, pId = "1231")

# Find all case reports having their identifier matching a regular expression
amber.case_reports(a, query = list(`data._id[$search]` = "^12"))

# Find all case reports which form data is equal to some value
# (will not work if the data are encrypted in the database)
amber.case_reports(a, query = list(data.PATIENT.ORIGIN_REGION = "xyz"))

# Export records collected with a study's form in a specific version
amber.case_reports(a,
  study = "Trauma Registry",
  form = "Adult trauma",
  query = list(revision = 6))

# Export records collected with a specific case report form
amber.case_reports(a, caseReportForm = "Adult trauma - test")

# Export records collected with a study's form in all versions used
amber.case_reports(a,
  study = "Trauma Registry",
  form = "Adult trauma")

amber.logout(a)
}
}
\seealso{
Other studies functions: 
\code{\link{amber.campaigns}()},
\code{\link{amber.campaign}()},
\code{\link{amber.case_report_export}()},
\code{\link{amber.case_report_forms}()},
\code{\link{amber.case_report_form}()},
\code{\link{amber.form_revisions}()},
\code{\link{amber.form_revision}()},
\code{\link{amber.forms}()},
\code{\link{amber.form}()},
\code{\link{amber.interview_designs}()},
\code{\link{amber.interview_design}()},
\code{\link{amber.interview_export}()},
\code{\link{amber.interviews}()},
\code{\link{amber.participants}()},
\code{\link{amber.participant}()},
\code{\link{amber.studies}()},
\code{\link{amber.study}()}
}
\concept{studies functions}
