% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/netplot.R
\name{netplot}
\alias{netplot}
\title{Network plotting}
\usage{
netplot(Y,X=NULL,xaxt="n",yaxt="n",xlab="",ylab="",
 lcol="gray",ncol="black",lwd=1,lty=1,pch=16,bty="n",plotnames=FALSE,
 seed=1,
 plot.iso=TRUE,directed=NULL,add=FALSE,...)
}
\arguments{
\item{Y}{a sociomatrix}

\item{X}{coordinates for plotting the nodes}

\item{xaxt}{x-axis type}

\item{yaxt}{y-axis type}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{lcol}{edge color}

\item{ncol}{node color (can be node-specific)}

\item{lwd}{line width}

\item{lty}{line type}

\item{pch}{plotting character for nodes (can be node-specific)}

\item{bty}{bounding box type}

\item{plotnames}{plot rownames of Y as node labels}

\item{seed}{random seed}

\item{plot.iso}{include isolates in plot}

\item{directed}{draw arrows}

\item{add}{add to an existing plot region}

\item{\ldots}{additional plotting parameters}
}
\description{
Plot the graph of a sociomatrix
}
\examples{
data(addhealthc3)
Y<-addhealthc3$Y
X<-xnet(Y)
netplot(Y,X)
}
\author{
Peter Hoff
}

