% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/habitat_kernel.R, R/movement_kernel.R,
%   R/simulate_ud.R
\name{habitat_kernel}
\alias{habitat_kernel}
\alias{movement_kernel}
\alias{sim_ud}
\alias{simulate_ud}
\alias{simulate_tud}
\title{Simulate UD from fitted SSF}
\usage{
habitat_kernel(coef, resources, exp = TRUE)

movement_kernel(scale, shape, template, quant = 0.99)

simulate_ud(movement_kernel, habitat_kernel, start, n = 100000L)

simulate_tud(movement_kernel, habitat_kernel, start, n = 100, n_rep = 5000)
}
\arguments{
\item{coef}{\code{[list]} \cr Vector with coeffiecients, not yet implemented.}

\item{resources}{\code{[RasterLayer, RasterStack]} \cr The resources.}

\item{exp}{A logical scalar, indicating whether or not the resulting habitat kernel should be exponentiated. This is usually \code{TRUE}.}

\item{scale, shape}{\code{[numeric](1)}\cr Scale and scale parameter of the gamma distribution of step lengths.}

\item{template}{\code{[RasterLayer,RasterStack]}\cr A raster serving as template for the simulations.}

\item{quant}{A numeric scalar, quantile of the step-length distribution that is
the maximum movement distance.}

\item{movement_kernel}{\code{[RasterLayer]} \cr The movement kernel.}

\item{habitat_kernel}{\code{[RasterLayer]} \cr The habitat kernel.}

\item{start}{\code{[numeric(2)]} \cr Starting point of the simulation.}

\item{n}{\code{[integer(1)=1e5]} \cr The number of simulation steps.}

\item{n_rep}{\code{[integer(1)=5e3]{>0}} \cr The number of times the animal walks of the final position. The mean of all replicates is returned.}
}
\value{
The habitat kernel, as \code{RasterLayer}.
}
\description{
Function to obtain a habitat kernel from a fitted (i)SSF.
}
\details{
\strong{\code{movement_kernel()}:} calculates a movement kernel from a fitted
(i)SSF. The method is currently only implemented for the gamma
distribution.

The habitat kernel is calculated by multiplying resources with their corresponding coefficients from the fitted (i)SSF.

\strong{\code{simulate_ud()}:} simulates a utilization distribution (UD) from a fitted Step-Selection Function.

\strong{\code{simulate_tud()}:} Is a conviencience wrapper arround \code{simulate_ud} to simulate transition UDs (i.e., starting at the same position many times and only simulate for a short time).
}
\note{
This functions are still experimental and should be used with care. If in doubt, please contact the author.
}
\references{
\insertRef{avgar2016}{amt}
\insertRef{signer2017}{amt}
}
\author{
Johannes Signer (jmsigner@gmail.com)
}
