% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insepct.R
\name{inspect}
\alias{inspect}
\alias{inspect.track_xy}
\title{Inspect a track}
\usage{
inspect(x, ...)

\method{inspect}{track_xy}(x, popup = NULL, cluster = TRUE, ...)
}
\arguments{
\item{x}{\code{[track_xy, track_xyt]} \cr A track created with \code{make_track}.}

\item{...}{Further arguments, none implemented.}

\item{popup}{\verb{[character(nrow(x))]} \cr Optional labels for popups.}

\item{cluster}{\verb{[logical(1)]} \cr If \code{TRUE} points are clustered at lower zoom levels.}
}
\value{
An interactive \code{leaflet} map.
}
\description{
Provides a very basic interface to \code{leaflet} and lets the user inspect relocations on an interactive map.
}
\note{
Important, \code{x} requires a valid coordinate reference system.
}
\examples{
data(sh)
x <- track(x = sh$x, y = sh$y, crs = sp::CRS("+init=epsg:31467"))

\dontrun{
inspect(x)
inspect(x, cluster = FALSE)
inspect(x, popup = 1:nrow(x), cluster = FALSE)
}
}
\seealso{
\code{leaflet::leaflet()}
}
