% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_chronotime}
\alias{get_chronotime}
\title{Measure elapsed time with C++11 chrono library}
\usage{
get_chronotime()
}
\value{
A double with the number of nanoseconds elapsed since a fixed epoch.
}
\description{
Returns a time indicator that can be used to accurately measure elapsed time. The C++11 clock used is \code{chrono::high_resolution_clock}.
}
\examples{
# Measure 1 second sleep
initT<-get_chronotime()
Sys.sleep(1)
measT<-(get_chronotime()-initT)*1e-9
cat("1 second passed in ",measT," seconds.\\n")
}
