% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/domain-records.R
\name{as.domain_record}
\alias{as.domain_record}
\alias{as.domain_record.domain_record}
\alias{as.domain_record.list}
\alias{as.url.domain_record}
\alias{domain_record_create}
\alias{domain_record_delete}
\alias{domain_records}
\title{List, create and delete domain records.}
\usage{
as.domain_record(x, domain)

\method{as.domain_record}{list}(x, domain)

\method{as.domain_record}{domain_record}(x, domain)

\method{as.url}{domain_record}(x, ...)

domain_records(domain, ...)

domain_record_create(domain, type, name = NULL, data = NULL,
  priority = NULL, port = NULL, weight = NULL, ...)

domain_record_delete(domain_record, ...)
}
\arguments{
\item{x}{Domain record.}

\item{domain}{(domain) Required. Domain Name (e.g. domain.com), specifies
the domain for which to create a record.}

\item{...}{Further args passed on the curl call to the web.}

\item{type}{(character) Required. The type of record you would like to
create. 'A', 'CNAME', 'NS', 'TXT', 'MX' or 'SRV'}

\item{name}{(character) The host name, alias, or service being defined by
the record. Required for 'A', 'CNAME', 'TXT' and 'SRV' records}

\item{data}{(character) Variable data depending on record type. Required
for 'A', 'AAAA', 'CNAME', 'MX', 'TXT', 'SRV', and 'NS' records}

\item{priority}{(integer) Required for 'SRV' and 'MX' records}

\item{port}{(integer) Required for 'SRV' records}

\item{weight}{(integer) Required for 'SRV' records}

\item{domain_record}{A domain record.}
}
\description{
List, create and delete domain records.
}
\examples{
\dontrun{
d <- domains()[[1]]
domain_records(d)

dr <- domain_record_create(d, "TXT", data = "Hi Mom!")
domain_records(d)
domain_record_delete(dr)
}
}

