% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firewalls.R
\name{firewall_add_tags}
\alias{firewall_add_tags}
\alias{firewall_remove_tags}
\title{Add/remove tags to a firewall}
\usage{
firewall_add_tags(id, tags, ...)

firewall_remove_tags(id, tags, ...)
}
\arguments{
\item{id}{(character) A firewall id (not the name) to delete}

\item{tags}{(character) tag strings}

\item{...}{Options passed on to httr::POST or httr::DELETE}
}
\description{
Add/remove tags to a firewall
}
\examples{
\dontrun{
drops <- droplets_create()
drop_ids <- vapply(drops, "[[", numeric(1), "id")
inbound <- list(list(protocol = "tcp", ports = "80", 
  sources = list(addresses = "18.0.0.0/8")))
outbound <- list(list(protocol = "tcp", ports = "80", 
  destinations = list(addresses = "0.0.0.0/0")))
res <- firewall_create("myfirewall", inbound, outbound)

tag_create(name = "foobar")
tags()
firewall_add_tags(id = res$id, tags = "foobar")
firewalls()[[1]]$tags
firewall_remove_tags(id = res$id, tags = "foobar")
}
}
