% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions.R
\docType{methods}
\name{getOutputById}
\alias{getOutputById}
\alias{getOutputById,BaseAnalysisPipeline-method}
\title{Obtains a specific output}
\usage{
getOutputById(object, reqId, includeCall = F)

\S4method{getOutputById}{BaseAnalysisPipeline}(object, reqId,
  includeCall = F)
}
\arguments{
\item{object}{The \code{AnalysisPipeline} or \code{StreamingAnalysisPipeline} object}

\item{reqId}{The position of the function for which the output is desired in the sequence of operations in the pipeline.}

\item{includeCall}{Logical which defines whether the call used to generate the output should be returned. By, default this is false}
}
\value{
If includeCall = F, the output object generated by the function is returned

If includeCall = T, it is a list containing to elements
        - call: tibble with 1 row containing the function call for the output desired
        - output: output generated
}
\description{
Obtains a specific output
}
\details{
Obtains a specific output from the \code{AnalysisPipeline} or \code{StreamingAnalysisPipeline} object by passing the position
     of the function for which the output is desired, in the sequence of operations in the pipeline. This can be obtained by passing the number
     under the 'id' column in the pipeline table corresponding to the required function

This method is implemented on the base class as it is a shared functionality types of Analysis Pipelines
which extend this class
}
\examples{
\dontrun{
library(analysisPipelines)
pipelineObj <- AnalysisPipeline(input = iris)
getNumRows <- function(dataset){
  return(nrow(dataset))
}
registerFunction("getNumRows")
pipelineObj \%>>\% getNumRows(storeOutput = TRUE) -> pipelineObj
pipelineObj \%>>\% generateOutput \%>>\% getOutputById("1")
}
}
\seealso{
Other Package core functions: \code{\link{BaseAnalysisPipeline-class}},
  \code{\link{MetaAnalysisPipeline-class}},
  \code{\link{assessEngineSetUp}},
  \code{\link{checkSchemaMatch}},
  \code{\link{createPipelineInstance}},
  \code{\link{exportAsMetaPipeline}},
  \code{\link{generateOutput}},
  \code{\link{genericPipelineException}},
  \code{\link{getInput}}, \code{\link{getLoggerDetails}},
  \code{\link{getPipelinePrototype}},
  \code{\link{getPipeline}}, \code{\link{getRegistry}},
  \code{\link{initDfBasedOnType}},
  \code{\link{initialize,BaseAnalysisPipeline-method}},
  \code{\link{loadMetaPipeline}},
  \code{\link{loadPipeline}},
  \code{\link{loadPredefinedFunctionRegistry}},
  \code{\link{loadRegistry}}, \code{\link{prepExecution}},
  \code{\link{registerFunction}},
  \code{\link{savePipeline}}, \code{\link{saveRegistry}},
  \code{\link{setInput}}, \code{\link{setLoggerDetails}},
  \code{\link{updateObject}},
  \code{\link{visualizePipeline}}
}
\concept{Package core functions}
