% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions.R
\name{loadRegistry}
\alias{loadRegistry}
\title{Loads a function registry from a file}
\usage{
loadRegistry(path)
}
\arguments{
\item{path}{path on the file system, where the registry is to be loaded from}
}
\description{
Loads a function registry from a file
}
\details{
This function loads a function registry and associated function definition stored in an RDS file into the
environment. The existing registry is overwritten with the newly loaded registry
}
\examples{
\dontrun{
  library(analysisPipelines)
  loadRegistry(path = "./registry.RDS")
}
}
\seealso{
Other Package core functions: \code{\link{BaseAnalysisPipeline-class}},
  \code{\link{MetaAnalysisPipeline-class}},
  \code{\link{assessEngineSetUp}},
  \code{\link{checkSchemaMatch}},
  \code{\link{createPipelineInstance}},
  \code{\link{exportAsMetaPipeline}},
  \code{\link{generateOutput}},
  \code{\link{genericPipelineException}},
  \code{\link{getInput}}, \code{\link{getLoggerDetails}},
  \code{\link{getOutputById}},
  \code{\link{getPipelinePrototype}},
  \code{\link{getPipeline}}, \code{\link{getRegistry}},
  \code{\link{initDfBasedOnType}},
  \code{\link{initialize,BaseAnalysisPipeline-method}},
  \code{\link{loadMetaPipeline}},
  \code{\link{loadPipeline}},
  \code{\link{loadPredefinedFunctionRegistry}},
  \code{\link{prepExecution}},
  \code{\link{registerFunction}},
  \code{\link{savePipeline}}, \code{\link{saveRegistry}},
  \code{\link{setInput}}, \code{\link{setLoggerDetails}},
  \code{\link{updateObject}},
  \code{\link{visualizePipeline}}
}
\concept{Package core functions}
