% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{getTableConfiguration}
\alias{getTableConfiguration}
\title{getTableConfiguration}
\usage{
getTableConfiguration(auth, report.suite.id, table.name = NULL,
  table.id = NULL)
}
\arguments{
\item{auth}{Authentication instance. result of \code{\link{authenticate}} function}

\item{report.suite.id}{ID number (as numeric or character) of the data suite}

\item{table.name}{name of table found in 'name' field of table information, i.e. not the tableName field}

\item{table.id}{should only be defined if table.name is not (otherwise, only table.id will be kept). Useful if two tables have the same name.}
}
\value{
List of objects defining the table configuration, used to download data from the Anametrix platform.
}
\description{
Get configuration information about table table.name from datasuite report.suite.id
}
\examples{
username <- "demo.user@demoanametrix.com"
password <- "password"
if (!authenticationCheck(auth)) 
auth <- authenticate("https://demo.anametrix.com/api", username, password)
browser.table    <- getTableConfiguration(auth, 10385, "Browsers")

}
\seealso{
Other dowload/upload functions: \code{\link{getAnametrixDataset}},
  \code{\link{getAxDatasetFromEncodedQuery}},
  \code{\link{uploadData}}
}

