% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_language.R
\name{set_language}
\alias{set_language}
\title{Change the language of the current R environment}
\usage{
set_language(language)
}
\arguments{
\item{language}{A language code.

Codes should should be two or three lowercase letters representing the
language, optionally followed by an underscore and two uppercase letters
representing a territory.
For example, \code{"es"} represents Spanish and
\code{"en_US"} represents American English.

If a territory is specified but there is no specific translation for that
territory, translations fall back to the general language.
For example, if there are no specific translations for Canadian French,
\code{"fr_CA"} will fall back to \code{"fr"}.

If a language is specified but there is no translation for that language,
translations generally fall back to English.

If \code{language} is an empty string or \code{NULL}, the \code{LANGUAGE} environment
variable is unset.}
}
\value{
Returns the pre-existing value of the \code{LANGUAGE} environment variable
}
\description{
Changes the value of the \code{LANGUAGE} environment variable.

Returns the value of the \code{LANGUAGE} environment variable before it
was changed.
This allows you to use the following structure to temporarily change
the language:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{old_language <- set_language("es")
on.exit(set_language(old_language))
}\if{html}{\out{</div>}}
}
\examples{
# Change language to Korean
set_language("ko")

# Change language to Mexican Spanish, which may fall back to "es"
set_language("es_MX")

# Temporarily set the language to Cantonese
old_language <- set_language("yue")
set_language(old_language)

# Change to an invalid language, which generally falls back to English
set_language("zxx")

# Unset the language environment variable
set_language(NULL)

}
