% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shade3d.R
\name{shade3d}
\alias{shade3d}
\alias{shade3d.TRI}
\alias{shade3d.TRI0}
\alias{shade3d.PATH}
\alias{shade3d.PATH0}
\alias{shade3d.DEL}
\alias{shade3d.DEL0}
\alias{shade3d.QUAD}
\alias{shade3d.BasicRaster}
\alias{shade3d.matrix}
\alias{shade3d.sfc}
\alias{shade3d.sf}
\alias{shade3d.SC}
\alias{shade3d.SC0}
\alias{shade3d.Spatial}
\alias{shade3d.triangulation}
\title{Draw a mesh as surfaces in 3D}
\usage{
\method{shade3d}{TRI}(x, ...)

\method{shade3d}{TRI0}(x, ...)

\method{shade3d}{PATH}(x, ...)

\method{shade3d}{PATH0}(x, ...)

\method{shade3d}{DEL}(x, ...)

\method{shade3d}{DEL0}(x, ...)

\method{shade3d}{QUAD}(x, ...)

\method{shade3d}{BasicRaster}(x, ...)

\method{shade3d}{matrix}(x, ...)

\method{shade3d}{sfc}(x, ...)

\method{shade3d}{sf}(x, ...)

\method{shade3d}{SC}(x, ...)

\method{shade3d}{SC0}(x, ...)

\method{shade3d}{Spatial}(x, ...)

\method{shade3d}{triangulation}(x, ...)
}
\arguments{
\item{x}{sp, sf, raster, or any other surface model understood by anglr/silicate}

\item{...}{pass \link[rgl:material]{material3d properties} to rgl}
}
\description{
Draw surfaces with rgl from any \link[rgl:mesh3d]{shape3d} classed object. Produces
a 3D surface plot from a mesh-alike object.
}
\details{
Objects that are not explicitly surfaces will be triangulated in order to
produce the mesh. Whether this is a good idea or not is an open question, and
some conversions will fail due to "extra" attributes like z or time stored on
vertices. Polygons are only implicit surfaces but these are usually
unproblematic to triangulate so this is done.
}
\examples{
rgl::open3d()
shade3d(volcano)

\donttest{
## create a globe plot of land areas with elevation
rgl::open3d()
world <- copy_down(DEL(simpleworld, max_area = 0.5), gebco * 50)
shade3d(globe(world), specular = "black", color = "white")
rgl::spheres3d(0, 0, 0, radius = 6378000, col = "dodgerblue", alpha = 0.75)
rgl::bg3d("black")
}
}
\seealso{
\link{plot3d} \link{as.mesh3d} \link{persp3d} \link{dot3d} \link{wire3d} \link{mesh_plot}
}
