% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.qqnorm.R
\name{sim.qqnorm}
\alias{sim.qqnorm}
\title{Simulation of QQ plots for the Normal distribution}
\usage{
sim.qqnorm(n = 20, last.plot = NULL, ...)
}
\arguments{
\item{n}{integer: sample size}

\item{last.plot}{an expression to be evaluated after the plot is drawn, e.g.
\code{expression(abline(0, 1))} to add the diagonal line}

\item{...}{other arguments passed to \code{\link{qqnorm}}}
}
\value{
\code{NULL}
}
\description{
This demo shows the possible QQ plots created by random numbers generated
from a Normal distribution so that users can get a rough idea about how QQ
plots really look like.
}
\details{
When the sample size is small, it is hard to get a correct inference about
the distribution of data from a QQ plot. Even if the sample size is large,
usually there are outliers far away from the straight line. Therefore, don't
overinterpret the QQ plots.
}
\seealso{
\code{\link{qqnorm}}
}
\author{
Yihui Xie
}
