% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anomalize.R
\name{anomalize}
\alias{anomalize}
\title{Detect anomalies using the tidyverse}
\usage{
anomalize(
  data,
  target,
  method = c("iqr", "gesd"),
  alpha = 0.05,
  max_anoms = 0.2,
  verbose = FALSE
)
}
\arguments{
\item{data}{A \code{tibble} or \code{tbl_time} object.}

\item{target}{A column to apply the function to}

\item{method}{The anomaly detection method. One of \code{"iqr"} or \code{"gesd"}.
The IQR method is faster at the expense of possibly not being quite as accurate.
The GESD method has the best properties for outlier detection, but is loop-based
and therefore a bit slower.}

\item{alpha}{Controls the width of the "normal" range.
Lower values are more conservative while higher values are less prone
to incorrectly classifying "normal" observations.}

\item{max_anoms}{The maximum percent of anomalies permitted to be identified.}

\item{verbose}{A boolean. If \code{TRUE}, will return a list containing useful information
about the anomalies. If \code{FALSE}, just returns the data expanded with the anomalies and
the lower (l1) and upper (l2) bounds.}
}
\value{
Returns a \code{tibble} / \code{tbl_time} object or list depending on the value of \code{verbose}.
}
\description{
The \code{anomalize()} function is used to detect outliers in a distribution
with no trend or seasonality present. It takes the output of \code{\link[=time_decompose]{time_decompose()}},
which has be de-trended and applies anomaly detection methods to identify outliers.
}
\details{
The return has three columns:
"remainder_l1" (lower limit for anomalies), "remainder_l2" (upper limit for
anomalies), and "anomaly" (Yes/No).

Use \code{\link[=time_decompose]{time_decompose()}} to decompose a time series prior to performing
anomaly detection with \code{anomalize()}.  Typically, \code{anomalize()} is
performed on the "remainder" of the time series decomposition.

For non-time series data (data without trend), the \code{anomalize()} function can
be used without time series decomposition.

The \code{anomalize()} function uses two methods for outlier detection
each with benefits.

\strong{IQR}:

The IQR Method uses an innerquartile range of 25\% and 75\% to establish a baseline distribution around
the median. With the default \code{alpha = 0.05}, the limits are established by expanding
the 25/75 baseline by an IQR Factor of 3 (3X). The IQR Factor = 0.15 / alpha (hense 3X with alpha = 0.05).
To increase the IQR Factor controling the limits, decrease the alpha, which makes
it more difficult to be an outlier. Increase alpha to make it easier to be an outlier.

The IQR method is used in \href{https://github.com/robjhyndman/forecast}{\code{forecast::tsoutliers()}}.

\strong{GESD}:

The GESD Method (Generlized Extreme Studentized Deviate Test) progressively
eliminates outliers using a Student's T-Test comparing the test statistic to a critical value.
Each time an outlier is removed, the test statistic is updated. Once test statistic
drops below the critical value, all outliers are considered removed. Because this method
involves continuous updating via a loop, it is slower than the IQR method. However, it
tends to be the best performing method for outlier removal.

The GESD method is used in \href{https://github.com/twitter/AnomalyDetection}{\code{AnomalyDection::AnomalyDetectionTs()}}.
}
\examples{
\dontrun{
library(dplyr)

# Needed to pass CRAN check / This is loaded by default
set_time_scale_template(time_scale_template())

data(tidyverse_cran_downloads)

tidyverse_cran_downloads \%>\%
    time_decompose(count, method = "stl") \%>\%
    anomalize(remainder, method = "iqr")
}

}
\references{
\enumerate{
\item \href{https://stats.stackexchange.com/questions/69874/how-to-correct-outliers-once-detected-for-time-series-data-forecasting}{How to correct outliers once detected for time series data forecasting? Cross Validated, https://stats.stackexchange.com}
\item \href{https://stats.stackexchange.com/questions/1142/simple-algorithm-for-online-outlier-detection-of-a-generic-time-series?}{Cross Validated: Simple algorithm for online outlier detection of a generic time series. Cross Validated, https://stats.stackexchange.com}
\item \href{https://www.usenix.org/system/files/conference/hotcloud14/hotcloud14-vallis.pdf}{Owen S. Vallis, Jordan Hochenbaum and Arun Kejariwal (2014). A Novel Technique for Long-Term Anomaly Detection in the Cloud. Twitter Inc.}
\item \href{https://github.com/twitter/AnomalyDetection}{Owen S. Vallis, Jordan Hochenbaum and Arun Kejariwal (2014). AnomalyDetection: Anomaly Detection Using Seasonal Hybrid Extreme Studentized Deviate Test. R package version 1.0.}
\item Alex T.C. Lau (November/December 2015). GESD - A Robust and Effective Technique for Dealing with Multiple Outliers. ASTM Standardization News. www.astm.org/sn
}
}
\seealso{
Anomaly Detection Methods (Powers \code{anomalize})
\itemize{
\item \code{\link[=iqr]{iqr()}}
\item \code{\link[=gesd]{gesd()}}
}

Time Series Anomaly Detection Functions (anomaly detection workflow):
\itemize{
\item \code{\link[=time_decompose]{time_decompose()}}
\item \code{\link[=time_recompose]{time_recompose()}}
}
}
