% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PricesMethods.R
\docType{methods}
\name{Prices-Methods}
\alias{Prices-Methods}
\alias{calcPrices,ANY-method}
\alias{calcPrices,Auction2ndCap-method}
\alias{calcPrices,Cournot-method}
\alias{calcPrices,Linear-method}
\alias{calcPrices,Logit-method}
\alias{calcPrices,LogLin-method}
\alias{calcPrices,AIDS-method}
\alias{calcPrices,LogitCap-method}
\alias{calcPrices,Auction2ndLogit-method}
\alias{calcPrices,VertBargBertLogit-method}
\alias{calcPrices,VertBarg2ndLogit-method}
\alias{calcPrices}
\title{\dQuote{Calculating Prices} Methods}
\usage{
\S4method{calcPrices}{Cournot}(object, preMerger = TRUE)

\S4method{calcPrices}{Auction2ndCap}(object, preMerger = TRUE, exAnte = TRUE)

\S4method{calcPrices}{Logit}(object, preMerger = TRUE, isMax = FALSE, subset, ...)

\S4method{calcPrices}{Auction2ndLogit}(object, preMerger = TRUE, exAnte = FALSE)

\S4method{calcPrices}{LogitCap}(object, preMerger = TRUE, isMax = FALSE, subset, ...)

\S4method{calcPrices}{Linear}(object, preMerger = TRUE, subset, ...)

\S4method{calcPrices}{LogLin}(object, preMerger = TRUE, subset, ...)

\S4method{calcPrices}{AIDS}(object, preMerger = TRUE, ...)

\S4method{calcPrices}{VertBargBertLogit}(object, preMerger = TRUE, ...)

\S4method{calcPrices}{VertBarg2ndLogit}(object, preMerger = TRUE, ...)
}
\arguments{
\item{object}{An instance of the respective class (see description for the classes)}

\item{preMerger}{If TRUE, the pre-merger ownership structure is used. If FALSE, the post-merger ownership structure is used.
Default is TRUE.}

\item{exAnte}{If \sQuote{exAnte} equals TRUE then the
\emph{ex ante} expected result for each firm is produced, while FALSE produces the
expected result conditional on each firm winning the auction. Default is FALSE.}

\item{isMax}{If TRUE, a check is run to determine if the calculated equilibrium price vector locally maximizes profits.
Default is FALSE.}

\item{subset}{A vector of length k where each element equals TRUE if
the product indexed by that element should be included in the
post-merger simulation and FALSE if it should be excluded. Default is a
length k vector of TRUE.}

\item{...}{For Logit, additional values that may be used to change the
default values of \code{\link[BB]{BBsolve}}, the non-linear equation solver.

For others, additional values that may be used to change the default values of \code{\link{constrOptim}}, the non-linear
equation solver used to enforce non-negative equilibrium quantities.}
}
\description{
For Auction2ndCap, the calcPrices method computes the expected price that the buyer pays,
conditional on the buyer purchasing from a particular firm.

For Logit, the calcPrices method computes either pre-merger or post-merger equilibrium prices under the assumptions
that consumer demand is Logit and firms play a differentiated product Bertrand Nash pricing game.

For LogitCap, the calcPrices method computes either pre-merger or post-merger equilibrium shares under the assumptions that
consumer demand is Logit and firms play a differentiated product Bertrand Nash pricing game with capacity constraints.

For Logit, the calcPrices method computes either pre-merger or post-merger equilibrium prices under the assumptions
that consumer demand is Logit and firms play a differentiated product Bertrand Nash pricing game.

For LogLin, the calcPrices method computes either pre-merger or post-merger equilibrium prices under the assumptions
that consumer demand is Log-Linear and firms play a differentiated product Bertrand Nash pricing game.

For AIDS, the calcPrices method computes either pre-merger or post-merger equilibrium prices under the assumptions
that consumer demand is AIDS and firms play a differentiated product Bertrand Nash pricing game.
It returns a length-k vector of NAs if the user did not supply prices.
}
\keyword{methods}
