% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PriceDeltaMethods.R
\docType{methods}
\name{PriceDelta-Methods}
\alias{PriceDelta-Methods}
\alias{calcPriceDelta}
\alias{calcPriceDelta,ANY-method}
\alias{calcPriceDelta,Antitrust-method}
\alias{calcPriceDelta,AIDS-method}
\alias{calcPriceDelta,Auction2ndLogit-method}
\alias{calcPriceDelta,Cournot-method}
\alias{calcPriceDelta,VertBargBertLogit-method}
\title{Methods For Calculating Price Delta}
\usage{
\S4method{calcPriceDelta}{Antitrust}(
  object,
  levels = FALSE,
  market = FALSE,
  index = c("paasche", "laspeyres"),
  ...
)

\S4method{calcPriceDelta}{Cournot}(object, levels = FALSE, market = TRUE, ...)

\S4method{calcPriceDelta}{VertBargBertLogit}(object, levels = FALSE, market = FALSE, ...)

\S4method{calcPriceDelta}{AIDS}(
  object,
  isMax = FALSE,
  levels = FALSE,
  subset,
  market = FALSE,
  index = c("paasche", "laspeyres"),
  ...
)

\S4method{calcPriceDelta}{Auction2ndLogit}(
  object,
  levels = TRUE,
  market = FALSE,
  exAnte = ifelse(market, TRUE, FALSE),
  ...
)
}
\arguments{
\item{object}{An instance of one of the classes listed above.}

\item{levels}{If TRUE, report results in levels. If FALSE, report results in percents. Default is FALSE.}

\item{market}{If TRUE, calculates (post-merger) share-weighted average of metric. Default is FALSE.}

\item{index}{If "paasche",calculates market-wide price changes using post-merger predicted shares. If  "laspeyres", 
calculates price index using pre-merger shares. Default is "paasche".}

\item{...}{Additional values that may be used to change the default values of the non-linear
equation solver.}

\item{isMax}{If TRUE, uses numerical derivatives to determine if
equilibrium price vector is a local maximum. Default is FALSE.}

\item{subset}{A vector of length k where each element equals TRUE if
the product indexed by that element should be included in the
post-merger simulation and FALSE if it should be excluded.Default is a
length k vector of TRUE.}

\item{exAnte}{If \sQuote{exAnte} equals TRUE then the
\emph{ex ante} expected result for each firm is produced, while FALSE produces the
expected result conditional on each firm winning the auction. Default is FALSE, unless \sQuote{market} is TRUE.}
}
\description{
For Antitrust, the method computes equilibrium price changes
due to a merger assuming that firms are playing a
Nash-Bertrand or Cournot game. This is a wrapper method for computing
the difference between pre- and post-merger equilbrium prices.

For AIDS, the method computes equilibrium price changes
due to a merger assuming that firms are playing a
Nash-Bertrand or Cournot game and LA-AIDS. This method calls a non-linear
equations solver to find a sequence of price changes that satisfy
the Bertrand FOCs.
}
\keyword{methods}
