\name{Bertrand}
\alias{Bertrand}
\alias{bertrand}
\alias{bertrand.alm}

\title{Bertrand Calibration and Merger Simulation With Logit, CES and AIDS Demand}

\description{Calibrates consumer demand using either a
  Logit, CES, or AIDS demand system and then simulates the prices effect of a merger between two firms
  under the assumption that all firms in the market are playing a Nash-Bertrand price setting game.}

\usage{


      bertrand.alm(demand = c("logit","ces","aids"),
  prices,shares_quantity,margins,
  ownerPre,ownerPost,
  mktElast = NA_real_,
  diversions,
  mcDelta=rep(0,length(prices)),
  subset=rep(TRUE,length(prices)),
  priceOutside=ifelse(demand== "logit",0, 1),
  priceStart = prices,
  isMax=FALSE,
  parmStart,
  control.slopes,
  control.equ,
  labels=paste("Prod",1:length(prices),sep=""),
  ...)
                     

}

\arguments{
  \item{}{Let k denote the number of products produced by all firms.}
  \item{demand}{A character vector indicating which demand system to use. Currently allows logit (default), ces, or aids.}
  \item{prices}{A length k vector product prices. Default is missing, in
  which case demand intercepts are not calibrated.}
  \item{shares_quantity}{A length k vector of product revenue shares. All shares must
    be between 0 and 1.}
  \item{margins}{A length k vector of product margins. All margins must
    be either be between 0 and 1, or NA.}
  \item{diversions}{A k x k matrix of diversion ratios with diagonal
    elements equal to -1. Default is missing, in which case diversion
    according to revenue share is assumed.}
  \item{ownerPre}{EITHER a vector of length k whose values
      indicate which firm produced a product before the merger OR a
      k x k matrix of pre-merger ownership shares. }
  \item{ownerPost}{EITHER a vector of length k whose values
    indicate which firm produced a product after the merger OR
    a k x k matrix of post-merger ownership shares.}
    \item{mktElast}{A negative number equal to the industry pre-merger
    price elasticity. Default is NAfor  \code{aids} and -1 for \code{pcaids} .}
  \item{mcDelta}{A vector of length k where each element equals the
    proportional change in a product's marginal costs due to
    the merger. Default is 0, which assumes that the merger does not
    affect any products' marginal cost.}
  \item{subset}{A vector of length k where each element equals TRUE if
  the product indexed by that element should be included in the
  post-merger simulation and FALSE if it should be excluded.Default is a
  length k vector of TRUE.}
  \item{parmStart}{\code{aids} only. A vector of length 2 who elements equal to an
  initial guess for "known" element of the diagonal of the demand matrix and the market elasticity.}
  \item{priceOutside}{A postive real number equal to the price of the outside good. 
  Default either equals 1 for Logit demand or 0 for CES demand.}
  \item{priceStart}{A vector of length k who elements equal to an
  initial guess of the proportional change in price caused by the
  merger. The default is to draw k random elements from a [0,1] uniform
  distribution.}
\item{isMax}{If TRUE, checks to see whether computed price equilibrium
  locally maximizes firm profits and returns a warning if not. Default is FALSE.}
\item{control.slopes}{A list of  \code{\link{optim}}  control parameters passed to the calibration routine optimizer (typically the \code{calcSlopes} method).}
    \item{control.equ}{A list of  \code{\link[BB]{BBsolve}} control parameters passed to the non-linear equation solver (typically the \code{calcPrices} method).}
  \item{labels}{A k-length vector of labels.}
  \item{...}{Additional options to feed to the \code{\link[BB]{BBsolve}}
  optimizer used to solve for equilibrium prices.}
 }



\details{

  The main purpose of this function is to provide a more convenient front-end
  for the \code{aids}, \code{logit.alm} and \code{ces} functions.

  Using price, and quantity, information for all products
  in each market, as well as margin information for at least
  one products in each market, \code{bertrand.alm} is able to
  recover the slopes and intercepts of either a Logit, CES, or AIDS demand
  system. These parameters are then used to simulate the price
  effects of a merger between
  two firms under the assumption that the firms are playing a
   simultaneous price setting game.
  
  
  \sQuote{ownerPre} and \sQuote{ownerPost} values will typically be equal to either 0
  (element [i,j] is not commonly owned) or 1 (element [i,j] is commonly
  owned), though these matrices may take on any value between 0 and 1 to
  account for partial ownership.

  

}

\value{\code{Bertrand} returns an instance of class \code{\linkS4class{LogitALM}}, 
\code{\linkS4class{CESALM}}, or \code{\linkS4class{AIDS}}, depending upon the value of the ``demand'' argument.}





\author{Charles Taragin \email{charles.taragin@usdoj.gov}}


