% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pod_analysis.R
\name{pod_envelope_analysis}
\alias{pod_envelope_analysis}
\title{This function calculates the chemical's point of departure.}
\usage{
pod_envelope_analysis(bmr_obj, slope_data, slope_threshold = 1,
  lower_interpolation_range, upper_interpolation_range, interval_size,
  agonist_assay = TRUE)
}
\arguments{
\item{bmr_obj}{a \code{bmr} object that holds all of the bootstrap
metaregression models produced.}

\item{slope_data}{the \code{data.frame} object that contains the
concentration and slope data.}

\item{slope_threshold}{the \code{numeric} object that sets the threshold
for the slope. This determines the upper bound on the concentration range
that is determined to be the asymptote. In other words, the asymptote is
defined as that region that has a slope less than the threshold at the lower
end of the concentration-response curve.}

\item{lower_interpolation_range}{a \code{numeric} value where the
interpolation should be bounded on the lower end.}

\item{upper_interpolation_range}{a \code{numeric} value where the
interpolation should be bounded on the upper end.}

\item{interval_size}{a \code{numeric} value that specifies how large the
interval should be between each value used for interpolation between
the lower and upper bounds.}

\item{agonist_assay}{a \code{boolean} value that specifies if the assay
is an agonist or antagonist assay.}
}
\value{
a two column \code{data.frame} that contains the chemical's point
of departure and the threshold value.
}
\description{
This function calculates the chemical's point of departure based on the
concentration-response data.
}
\examples{
bmr_obj <- bootstrap_metaregression(oxybenzone, 15, 100)
slope_pod <- slope_pod_analysis(bmr_obj, 0.0001, 10, 0.1)
pod_and_threshold <- pod_envelope_analysis(bmr_obj, slope_pod,
  slope_threshold = 10, min(oxybenzone$Concentration),
  max(oxybenzone$Concentration), interval_size = 0.1)
}

