% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz.R
\name{sedona_render_heatmap}
\alias{sedona_render_heatmap}
\title{Visualize a Sedona spatial RDD using a heatmap.}
\usage{
sedona_render_heatmap(
  rdd,
  resolution_x,
  resolution_y,
  output_location,
  output_format = c("png", "gif", "svg"),
  boundary = NULL,
  blur_radius = 10L,
  overlay = NULL,
  browse = interactive()
)
}
\arguments{
\item{rdd}{A Sedona spatial RDD.}

\item{resolution_x}{Resolution on the x-axis.}

\item{resolution_y}{Resolution on the y-axis.}

\item{output_location}{Location of the output image. This should be the
desired path of the image file excluding extension in its file name.}

\item{output_format}{File format of the output image. Currently "png",
"gif", and "svg" formats are supported (default: "png").}

\item{boundary}{Only render data within the given rectangular boundary.
The `boundary` parameter can be set to either a numeric vector of
c(min_x, max_y, min_y, max_y) values, or with a bounding box object
e.g., new_bounding_box(sc, min_x, max_y, min_y, max_y), or NULL
(the default). If `boundary` is NULL, then the minimum bounding box of the
input spatial RDD will be computed and used as boundary for rendering.}

\item{blur_radius}{Controls the radius of a Gaussian blur in the resulting
heatmap.}

\item{overlay}{A \code{viz_op} object containing a raster image to be
displayed on top of the resulting image.}

\item{browse}{Whether to open the rendered image in a browser (default:
interactive()).}
}
\value{
No return value.
}
\description{
Generate a heatmap of geometrical object(s) within a Sedona spatial RDD.
}
\examples{

library(sparklyr)
library(apache.sedona)

sc <- spark_connect(master = "spark://HOST:PORT")

if (!inherits(sc, "test_connection")) {
  input_location <- "/dev/null" # replace it with the path to your input file
  rdd <- sedona_read_dsv_to_typed_rdd(
    sc,
    location = input_location,
    type = "point"
  )

  sedona_render_heatmap(
    rdd,
    resolution_x = 800,
    resolution_y = 600,
    output_location = tempfile("points-"),
    output_format = "png",
    boundary = c(-91, -84, 30, 35),
    blur_radius = 10
  )
}

}
\seealso{
Other Sedona visualization routines: 
\code{\link{sedona_render_choropleth_map}()},
\code{\link{sedona_render_scatter_plot}()}
}
\concept{Sedona visualization routines}
