% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{sim_fun_on_tree}
\alias{sim_fun_on_tree}
\title{Simulate functions on a ginven tree}
\usage{
sim_fun_on_tree(
  tree,
  tip.type,
  node.type,
  psi,
  mu_d,
  mu_s,
  eta,
  Pi,
  P = 1L,
  informative = getOption("aphylo_informative", FALSE),
  maxtries = 20L
)
}
\arguments{
\item{tree}{An object of class \link[ape:read.tree]{phylo}}

\item{tip.type, node.type}{Integer vectors with values {0,1}. 0 denotes duplication node and 1 speciation node. This is used in \link{LogLike}.}

\item{psi}{Numeric vector of length 2. Misclasification probabilities. (see \code{\link{LogLike}}).}

\item{mu_d, mu_s}{Numeric vector of length 2. Gain/loss probabilities (see \code{\link{LogLike}}).}

\item{eta}{Numeric vector of length 2. Annotation bias probabilities (see \code{\link{LogLike}}).}

\item{Pi}{Numeric scalar. Root node probability of having the function (see \code{\link{LogLike}}).}

\item{P}{Integer scalar. Number of functions to simulate.}

\item{informative}{Logical scalar. When \code{TRUE} (default) the function
re-runs the simulation algorithm until both 0s and 1s show in the leaf
nodes of the tree.}

\item{maxtries}{Integer scalar. If \code{informative = TRUE}, then the function
will try at most \code{maxtries} times.}
}
\value{
An matrix of size \code{length(offspring)*P} with values 9, 0 and 1
indicating \code{"no information"}, \code{"no function"} and \code{"function"}.
}
\description{
Simulate functions on a ginven tree

\code{}
}
\details{
Using the model described in the vignette
\href{../doc/peeling_phylo.html}{peeling_phylo.html}

The optiona \code{informative} was created such that when needed the
function can be forced to simualte annotations while making sure (or at
least trying \code{maxtries} times) that the leafs have both 0s and 9s. From what
we've learned while conducting simulation studies, using this option may
indirectly bias the data generating process.
}
\examples{
# Example 1 ----------------------------------------------------------------
# We need to simulate a tree
set.seed(1231)
newtree <- sim_tree(1e3)

# Preprocessing the data

# Simulating
ans <- sim_fun_on_tree(
  newtree,
  psi  = c(.01, .05),
  mu_d = c(.90, .80),
  mu_s = c(.1, .05),
  Pi   = .5,
  eta  = c(1, 1)
)

# Tabulating results
table(ans)
}
