% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apm_est.R
\name{apm_est}
\alias{apm_est}
\alias{summary.apm_est}
\alias{plot.apm_est}
\title{Estimate ATTs from models fits}
\usage{
apm_est(
  fits,
  post_time,
  M = 0,
  R = 1000L,
  all_models = FALSE,
  cl = NULL,
  verbose = TRUE,
  ...
)

\method{summary}{apm_est}(object, level = 0.95, M = NULL, ...)

\method{plot}{apm_est}(x, label = TRUE, size.weights = TRUE, ...)
}
\arguments{
\item{fits}{an \code{apm_pre_fits} object; the output of a call to \code{\link[=apm_pre]{apm_pre()}}.}

\item{post_time}{the value of the time variable considered post-treatment, for which the ATT is to be estimated.}

\item{M}{the sensitivity parameter for set identification. For \code{apm_est()}, the default is 0, i.e., under point identification. For \code{summary()}, this can be set to one or more positive values to produce uncertainty bounds for each value. Only allowed when not set to 0 in the call to \code{apm_est()}. See Details.}

\item{R}{the number of bootstrap iterations used to compute the sampling variance of the ATT. Default is 1000. More is better but takes longer.}

\item{all_models}{\code{logical}; whether to compute ATTs for all models (\code{TRUE}) or just those with BMA weights greater than 0 (\code{FALSE}, default). This will not effect the final estimates but leaving as \code{FALSE} can speed up computation when some models have BMA weights of 0.}

\item{cl}{a cluster object created by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}, an integer to indicate number of child-processes (ignored on Windows) for parallel evaluations, or \code{"future"} to use a future backend. \code{NULL} (default) refers to sequential evaluation. See \code{\link[fwb:fwb]{fwb::fwb()}} for details and issues related to replicability.}

\item{verbose}{\code{logical}; whether to print information about the progress of the estimation, including a progress bar. Default is \code{TRUE}.}

\item{\dots}{other arguments passed to \code{\link[fwb:fwb]{fwb::fwb()}}.}

\item{level}{the desired confidence level. Set to 0 to ignore sampling variation in computing the interval bounds. Default is .95.}

\item{x, object}{an \code{apm_est} object; the output of a call to \code{apm_est()}.}

\item{label}{\code{logical}; whether to label the ATT estimates. Requires \pkg{ggrepel} to be installed. Default is \code{TRUE}.}

\item{size.weights}{\code{logicsl}; whether to size the points based on their BMA weights. Default is \code{TRUE}.}
}
\value{
\code{apm_est()} returns an \code{apm_est} object, which contains the ATT estimates and their variance estimates. The following components are included:
\describe{
\item{BMA_att}{the BMA-weighted ATT}
\item{atts}{a 1-column matrix containing the ATT estimates from each model (when \code{all_models = FALSE}, only models with positive BMA weights are included)}
\item{BMA_var}{the total variance estimate for the BMA-weighted ATT incorporating the variance due to sampling and due to model selection}
\item{BMA_var_b}{the bootstrap-based component of the variance estimate for the BMA-weighted ATT due to sampling}
\item{BMA_var_m}{the component of the variance estimate for the BMA-weighted ATT due to model selection}
\item{M}{the value of the sensitivity parameter \code{M}}
\item{post_time}{the value supplied to \code{post_time}}
\item{observed_means}{a matrix of the observed outcome means at each pre-treatment validation period}
\item{pred_errors}{an array containing the average prediction errors for each model and each pre-treatment validation period}
\item{pred_error_diffs}{a matrix containing the difference in average prediction errors between groups for each model and each pre-treatment validation period}
\item{BMA_weights}{the BMA weights computed by \code{apm_pre()} (when \code{all_models = FALSE}, only positive BMA weights are included)}
\item{boot_out}{an \code{fwb} object containing the bootstrap results}
}

\code{plot()} returns a \code{ggplot} object displaying the ATT for each model plotted against the maximum absolute difference in average prediction errors for that model. The model with the lowest maximum absolute difference in average prediction errors is displayed in red.

\code{summary()} produces a table with the BMA-weighted ATT, it's estimated standard error, and confidence interval limits. When \code{M} is greater than 0, additional rows for each value of \code{M} are included with the lower and upper bound. When \code{level} is greater than 0, these bounds include the uncertainty due to sampling and model selection; otherwise, they correspond to the set identification bounds for the ATT.
}
\description{
\code{apm_est()} computes the ATTs from the models previously fit by \code{\link[=apm_pre]{apm_pre()}}, choosing the optimal one by minimizing the largest absolute average prediction error across validation times. Optionally, this process can be simulated to arrive at a distribution of ATTs that accounts for the uncertainty in selecting the optimal model. \code{plot()} plots the resulting ATT(s).
}
\details{
\code{apm_est()} estimates the ATT from each model and combines them to form the BMA-weighted estimate of the ATT. Uncertainty for the BMA-weighted ATT is computed by combining two variance components, one that account for sampling and another that accounts for model selection. The component due to sampling is computed by bootstrapping the process of fitting the outcome model for the post-treatment outcome identified by \code{post_time} and computing the difference between the observed outcome mean difference and the model-predicted outcome mean difference. The fractional weighted bootstrap as implemented in \code{\link[fwb:fwb]{fwb::fwb()}} is used to ensure no units are dropped from the analysis. In each bootstrap sample, the BMA-weighted ATT estimate is computed as the weighted average of the ATTs computed from the models using the fixed BMA weights computed by \code{\link[=apm_pre]{apm_pre()}}, and the variance is computed as the empirical variance over the bootstrapped estimates. The variance component due to model selection is computed as the BMA-weighted variance of the original ATTs.

When \code{M} is greater than 0, bounds for set identification and their uncertainty are additionally computed. This involves bootstrapping the fitting of the pre-period models along with post-treatment models on order to compute the maximum absolute difference in average prediction errors for each model across validation periods. Each bootstrap sample produces a margin of error for each model computed as \eqn{M \times \delta_m} where \eqn{\delta_m} is the maximum absolute difference in average prediction errors for model \eqn{m}. Upper and lower bounds for the set-identified BMA-weighted ATT are computed as \eqn{\text{ATT}_m \pm M \times \delta_m}. The same procedure as above is then used to compute the variance of these bounds.

\code{summary()} displays the BMA-weighted ATT estimate, its standard error, and Wald confidence intervals. When \code{M} is greater than 0, bounds for the set-identified ATT are displayed in the confidence interval bound columns. The lower bound is computed as \eqn{\text{LB} - \sigma_{LB}Z_{l}} and the upper bound as \eqn{\text{UB} + \sigma_{UB}Z_{l}}, where \eqn{\text{LB}} and \eqn{\text{UB}} are the lower and upper bounds, \eqn{\sigma_{LB}} and \eqn{\sigma_{UB}} are their variances accounting for sampling and model selection, and \eqn{Z_{l}} is the critical Z-statistic for confidence level \eqn{l}. To display the set-identification bounds themselves, one should set \code{level = 0}.
}
\examples{
data("ptpdata")

# Combination of 4 models: 2 time trends, 2 lags
models <- apm_mod(list(crude_rate ~ 1),
                  lag = 0:1,
                  time_trend = 0:1)
models

# Fit the models to data; unit_var must be supplied for
# fixed effects
fits <- apm_pre(models,
                data = ptpdata,
                group_var = "group",
                time_var = "year",
                val_times = 2004:2007,
                unit_var = "state",
                nsim = 100,
                verbose = FALSE)

est <- apm_est(fits,
               post_time = 2008,
               M = 1,
               R = 20,
               verbose = FALSE)

est

# ATT estimate and bounds for M = 1
summary(est)

# Bounds for other values of M
summary(est, M = c(.5, 1, 1.5, 2))

# Set-ID bounds without uncertainty
summary(est, level = 0)

plot(est)
}
\seealso{
\code{\link[=apm_pre]{apm_pre()}} for computing the BMA weights; \code{\link[fwb:fwb]{fwb::fwb()}} for the fractional weighted bootstrap.
}
