% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_choiceAnalysis.R
\name{apollo_choiceAnalysis}
\alias{apollo_choiceAnalysis}
\title{Reports market share for subsamples}
\usage{
apollo_choiceAnalysis(choiceAnalysis_settings, apollo_control, database)
}
\arguments{
\item{choiceAnalysis_settings}{List. Contains settings for this function. User input is required for all settings except those with a default or marked as optional. 
         \itemize{
           \item \strong{code{alternatives}}: Named numeric vector. Names of alternatives and their corresponding value in \code{choiceVar}. Note that these need not necessarily be the alternatives as defined in the model, but could e.g. relate to cheapest/most expensive.
           \item \strong{code{avail}}: Named list of numeric vectors or scalars. Availabilities of alternatives, one element per alternative. Names of elements must match those in \code{alternatives}. Values can be 0 or 1. A user can also specify \code{avail=1} to indicate universal availability, or omit the setting completely.
           \item \strong{code{choiceVar}}: Numeric vector. Contains choices for all observations. It will usually be a column from the database. Values are defined in \code{alternatives}.
           \item \strong{code{explanators}}: data.frame. Variables determining subsamples of the database. Values in each column must describe a group or groups of individuals (e.g. socio-demographics). Most usually a subset of columns from the database.
           \item \strong{code{printToScreen}}: Logical. TRUE for returning output to screen as well as file. TRUE by default.
\item \strong{\code{rows}}: Boolean vector. Consideration of which rows to include. Length equal to the number of observations (nObs), with entries equal to TRUE for rows to include, and FALSE for rows to exclude. Default is \code{"all"}, equivalent to \code{rep(TRUE, nObs)}.
         }}

\item{apollo_control}{List. Options controlling the running of the code. See \link{apollo_validateInputs}.}

\item{database}{data.frame. Data used by model.}
}
\value{
Silently returns a matrix containing the mean value for each explanator for those cases where an alternative is chosen and where it is not chosen, 
        as well as the t-test comparing those means (H0: equivalence).
        The table is also written to a file called \code{modelName_choiceAnalysis.csv} and printed to screen.
}
\description{
Compares market shares across subsamples in dataset, and conducts statistical tests.
}
\details{
Saves the output to a csv file in the working/output directory.
}
