% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sse.R
\name{sse}
\alias{sse}
\title{Sum of Square Errors}
\usage{
sse(b, dataset)
}
\arguments{
\item{b}{vector or column-matrix of regression coefficients}

\item{dataset}{a matrix or dataframe. The final column is the outcome variable.}
}
\value{
The function returns the sum of square errors.
}
\description{
Compute the sum of squared prediction errors (or residual sum of squares)
when a linear model is applied to a dataset.
}
\examples{
## Using simulated data derived from the iris dataset
mu <- c(rep(0, 4))
covmatr <- matrix(c(0.7, -0.04, 1.3, 0.5, -0.04, 0.2, -0.3, -0.1,
1.3, -0.3, 3.1, 1.3, 0.5, -0.1, 1.3, 0.6), ncol = 4)
sim.dat <- randnor(n = 100, mu = mu, Cov = covmatr)
sim.dat <- cbind(1, sim.dat)
## resample and fit an ordinary least squares model, and then
## calculate the sum of square errors of the model when applied
## to the original data
sim.boot <- randboot(sim.dat, replace = TRUE)
boot.betas <- ols.rgr(sim.boot)
sse(b = boot.betas, dataset = sim.dat)
}

