% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apsim_met.R
\name{as_apsim_met}
\alias{as_apsim_met}
\title{Conversion from data frame to met object}
\usage{
as_apsim_met(
  x,
  filename = "noname.met",
  site = "nosite",
  latitude = 0,
  longitude = 0,
  tav = NA,
  amp = NA,
  colnames = c("year", "day", "radn", "maxt", "mint", "rain"),
  units = c("()", "()", "(MJ/m2/day)", "(oC)", "(oC)", "(mm)"),
  constants = NA,
  comments = NA,
  check = TRUE
)
}
\arguments{
\item{x}{object of class \sQuote{data frame}}

\item{filename}{default \sQuote{noname.met}}

\item{site}{default \sQuote{nosite}}

\item{latitude}{default is zero (0)}

\item{longitude}{default is zero (0)}

\item{tav}{average temperature (calculated if not supplied)}

\item{amp}{temperature amplitude (calculated if not supplied)}

\item{colnames}{default are \dQuote{year}, \dQuote{day}, \dQuote{radn}, 
\dQuote{maxt}, \dQuote{mint}, \dQuote{rain}}

\item{units}{default are \dQuote{()}, \dQuote{()}, \dQuote{(MJ/m2/day)},
\dQuote{(oC)}, \dQuote{(oC)}, \dQuote{(mm)}}

\item{constants}{default is \dQuote{NA}}

\item{comments}{default is \dQuote{NA}}

\item{check}{whether to check the resulting met file using \code{\link{check_apsim_met}}.
default is TRUE.}
}
\description{
It makes minimum assumptions about the data so it is recommended to change defaults
}
\details{
Simple utility for converting a data frame to an object of class met
}
