% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_isric_soil_profile.R
\name{get_isric_soil_profile}
\alias{get_isric_soil_profile}
\title{Generate a synthetic APSIM soil profile from the ISRIC soil database}
\usage{
get_isric_soil_profile(
  lonlat,
  statistic = c("mean", "Q0.5"),
  soil.profile,
  find.location.name = TRUE
)
}
\arguments{
\item{lonlat}{Longitude and latitude vector (e.g. c(-93, 42)).}

\item{statistic}{default is the mean}

\item{soil.profile}{a soil profile to fill in in case the default one is not appropriate}

\item{find.location.name}{default is TRUE. Use either maps package or photon API to find Country/State.
If you are running this function many times it might be better to set this to FALSE.}
}
\value{
it generates an object of class \sQuote{soil_profile}.
}
\description{
Retrieves soil data from the ISRIC global database and converts it to an APSIM soil_profile object
}
\details{
Source: https://www.isric.org/ \cr
Details: https://www.isric.org/explore/soilgrids/faq-soilgrids \cr

Pedotransfer functions: Saxton and Rawls, 2006. Soil Water Characteristic Estimates by Texture and Organic Matter for Hydrologic Solutions.
Soil Sci. Soc. Am. J. 70:1569–1578. \cr

TODO: need to look into how this is done in APSIM NG
https://github.com/APSIMInitiative/ApsimX/pull/3994/files \cr

NOTE: Eric Zurcher provided help by sending me an R file originally written by
Andrew Moore. It provides a bit of context for how some of the decisions
were made for constructing the synthetic soil profiles in APSIM. (email from june 3 2021).

Variable which are directly retrieved and a simple unit conversion is performed: \cr
* Bulk density - bdod \cr
* Carbon - soc \cr
* Clay - clay \cr
* Sand - sand \cr
* PH - phh2o \cr
* Nitrogen - nitrogen \cr
Variables which are estimated using pedotransfer functions: \cr
LL15, DUL, SAT, KS, AirDry \cr
TO-DO: \cr
What do I do with nitrogen? \cr
Can I use CEC? \cr
How can I have a guess at FBiom and Finert? \cr
FBiom does not depend on any soil property at the moment, should it? \cr
}
\examples{
\dontrun{
## Get soil profile properties for a single point
sp1 <- get_isric_soil_profile(lonlat = c(-93, 42))

## Visualize
plot(sp1)
plot(sp1, property = "water")


}
}
\seealso{
\code{\link{apsimx_soil_profile}}, \code{\link{edit_apsim_replace_soil_profile}}, \code{\link{edit_apsimx_replace_soil_profile}}.
}
\author{
Fernando E. Miguez, Eric Zurcher (CSIRO) and Andrew Moore (CSIRO)
}
