% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/initialize.R
\docType{class}
\name{IncidenceMatrix-class}
\alias{IncidenceMatrix-class}
\alias{.IncidenceMatrix}
\alias{IncidenceMatrix}
\title{Incidence Matrix}
\usage{
IncidenceMatrix(
  data = FALSE,
  nrow = 1,
  ncol = 1,
  byrow = FALSE,
  dimnames = NULL,
  ...
)
}
\arguments{
\item{data}{an optional data vector (including a list or
    \code{\link[base]{expression}} vector).  Non-atomic classed \R objects are
    coerced by \code{\link[base]{as.vector}} and all attributes discarded.}

\item{nrow}{the desired number of rows.}

\item{ncol}{the desired number of columns.}

\item{byrow}{logical. If \code{FALSE} (the default) the matrix is
    filled by columns, otherwise the matrix is filled by rows.}

\item{dimnames}{A \code{\link[base]{dimnames}} attribute for the matrix:
    \code{NULL} or a \code{list} of length 2 giving the row and column
    names respectively.  An empty list is treated as \code{NULL}, and a
    list of length one as row names.  The list can be named, and the
    list names will be used as names for the dimensions.}

\item{...}{additional arguments to be passed to or from methods.}
}
\description{
An S4 class to represent an incidence (presence/absence) matrix.
}
\section{Matrix ID}{

 When a matrix is first created, an identifier is generated (UUID v4).
 This ID is preserved when coercing to another class. Thus, the object ID is
 unique within the same class, but two objects of different classes can have
 the same ID. This makes it possible to identify objects representing the
 same initial data and associate them with the results of specific
 computations.
}

\section{Get and set}{

 In the code snippets below, \code{x} is a \code{*Matrix} object.
 \describe{
  \item{\code{get_id(x)}}{Get the ID of \code{x}.}
  \item{\code{get_dates(x)} and \code{set_dates(x) <- value}}{Get or set
  the dates of \code{x}.}
  \item{\code{get_coordinates(x)} and \code{set_coordinates(x) <- value}}{Get
  or set the geographical coordinates of \code{x}.}
 }
}

\section{Access}{

 In the code snippets below, \code{x} is a \code{*Matrix} object.
 \describe{
  \item{\code{dim(x)}}{Returns the dimension of \code{x}.}
  \item{\code{nrow(x)}}{Returns the number of rows present in \code{x}.}
  \item{\code{ncol(x)}}{Returns the number of columns present in \code{x}.}
  \item{\code{dimnames(x)}, \code{dimnames(x) <- value}}{Retrieves or sets
  the row dimnames of \code{x} according to \code{value}.}
  \item{\code{rownames(x)}, \code{rownames(x) <- value}}{Retrieves or sets
  the row names of \code{x} according to \code{value}.}
  \item{\code{colnames(x)}, \code{colnames(x) <- value}}{Retrieves or sets
  the column names of \code{x} according to \code{value}.}
 }
}

\section{Subset}{

 In the code snippets below, \code{x} is a \code{*Matrix} object.
 \describe{
  \item{\code{x[i, j]}}{Extracts elements selected by subscripts \code{i}
  and \code{j}. Indices are \code{\link{numeric}}, \code{\link{integer}} or
  \code{\link{character}} vectors or empty (missing) or \code{NULL}.
  Numeric values are coerced to \code{\link{integer}} as by
  \code{\link{as.integer}} (and hence truncated towards zero).
  Character vectors will be matched to the name of the elements.
  An empty index (a comma separated blank) indicates that all
  entries in that dimension are selected.
  Returns an object of the same class as \code{x}.}
  \item{\code{x[[i]]}}{Extracts a single element selected by subscript
  \code{i}.}
 }
}

\examples{
## Create an incidence (presence/absence) matrix
## Data will be coerced with as.logical()
A <- IncidenceMatrix(data = sample(0:1, 100, TRUE, c(1, 1/3)), nrow = 10)

## Create a count data matrix
B <- CountMatrix(data = sample(0:10, 100, TRUE), nrow = 10)
## Coerce to presence/absence
C <- as_incidence(B)
}
\seealso{
\linkS4class{LogicalMatrix}

Other matrix: 
\code{\link{AbundanceMatrix-class}},
\code{\link{CountMatrix-class}},
\code{\link{LogicalMatrix-class}},
\code{\link{Matrix-class}},
\code{\link{NumericMatrix-class}},
\code{\link{OccurrenceMatrix-class}},
\code{\link{SimilarityMatrix-class}},
\code{\link{StratigraphicMatrix-class}},
\code{\link{coerce}()}
}
\author{
N. Frerebeau
}
\concept{matrix}
