% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{assert_numeric}
\alias{assert_numeric}
\alias{assert_count}
\alias{assert_whole}
\alias{assert_positive}
\alias{assert_negative}
\alias{assert_odd}
\alias{assert_even}
\title{Check Numeric Values}
\usage{
assert_count(x, na.rm = FALSE, ...)

assert_whole(x, na.rm = FALSE, ...)

assert_positive(x, na.rm = FALSE, ...)

assert_negative(x, na.rm = FALSE, ...)

assert_odd(x, na.rm = FALSE, ...)

assert_even(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{A \code{\link{numeric}} object to be checked.}

\item{na.rm}{A \code{\link{logical}} scalar: should missing values (including \code{NaN})
be omitted?}

\item{...}{Extra parameters to be passed to internal methods.}
}
\value{
Throws an error, if any, and returns \code{x} invisibly otherwise.
}
\description{
Check Numeric Values
}
\seealso{
Other validation methods: 
\code{\link{assert_constant}()},
\code{\link{assert_data}},
\code{\link{assert_length}()},
\code{\link{assert_lower}()},
\code{\link{assert_names}()},
\code{\link{assert_package}()},
\code{\link{assert_square}()},
\code{\link{assert_type}()},
\code{\link{validate}()}
}
\author{
N. Frerebeau
}
\concept{validation methods}
