% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort.R
\name{sort}
\alias{sort}
\alias{SORT}
\alias{sort,associations-method}
\title{Sort Associations}
\usage{
\S4method{sort}{associations}(x, decreasing = TRUE, na.last = NA, by = "support", order = FALSE, ...)
}
\arguments{
\item{x}{an object to be sorted.}

\item{decreasing}{a logical. Should the sort be increasing or decreasing?
(default is decreasing)}

\item{na.last}{na.last is not supported for associations.  NAs are always
put last.}

\item{by}{a character string specifying the quality measure stored in
\code{x} to be used to sort \code{x}. If a vector of character strings is
specified then the additional strings are used to sort \code{x} in case of
ties.}

\item{order}{should a order vector (a permutation like \code{\link[=order]{order()}})
be returned instead of the sorted associations?}

\item{...}{Further arguments are ignored.}
}
\value{
An object of the same class as \code{x} or a permutation vector.
}
\description{
Provides the method \code{sort} to sort elements in class
\link{associations} (e.g., itemsets or rules) according to the
value of measures stored in the association's slot \code{quality} (e.g.,
support).
}
\details{
\code{sort} is relatively slow for large sets of associations since it has
to copy and rearrange a large data structure.
With \code{order = TRUE} an integer vector with the
order is returned instead of the reordered associations.

If only the top \code{n} associations are needed then \code{\link[=head]{head()}} using
\code{by} performs this faster than calling \code{sort()} and then \code{\link[=head]{head()}}
since it does it without copying and rearranging all the data.  \code{\link[=tail]{tail()}}
works in the same way.
}
\examples{
data("Adult")

## Mine rules with Apriori
rules <- apriori(Adult, parameter = list(supp = 0.6))

rules_by_lift <- sort(rules, by = "lift")

inspect(head(rules))
inspect(head(rules_by_lift))

## A faster/less memory consuming way to get the top 5 rules according to lift
## (see Details section)
inspect(head(rules, n = 5, by = "lift"))
}
\seealso{
Other associations functions: 
\code{\link{abbreviate}()},
\code{\link{associations-class}},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{inspect}()},
\code{\link{is.closed}()},
\code{\link{is.generator}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()},
\code{\link{is.superset}()},
\code{\link{itemsets-class}},
\code{\link{match}()},
\code{\link{rules-class}},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{associations functions}
\keyword{arith}
\keyword{manip}
