% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affinity.R
\name{affinity}
\alias{affinity}
\alias{affinity,matrix-method}
\alias{affinity,itemMatrix-method}
\title{Computing Affinity Between Items}
\usage{
affinity(x)

\S4method{affinity}{matrix}(x)

\S4method{affinity}{itemMatrix}(x)
}
\arguments{
\item{x}{a matrix or an object of class \link{itemMatrix} or
\link{transactions} containing itemsets.}
}
\value{
returns an object of class \linkS4class{ar_similarity} which represents the
affinities between items in \code{x}.
}
\description{
Provides the generic function \code{affinity()} and methods to compute
and return a similarity matrix with the affinities between items for a set
itemsets stored in a matrix or in \link{transactions} via its superclass \link{itemMatrix}.
}
\details{
Affinity between the two items \eqn{i} and \eqn{j} is defined by Aggarwal et
al. (2002) as \deqn{A(i,j) = \frac{supp(\{i,j\})}{supp(\{i\}) + supp(\{j\}) -
supp(\{i,j\})},}{A(i,j) = supp({i,j})/(supp({i}) + supp({j}) - supp({i,j})),}
where \eqn{supp(.)} is the support measure. Note that affinity is equivalent to the
Jaccard similarity between items.
}
\examples{
data("Adult")

## choose a sample, calculate affinities
s <- sample(Adult, 500)
s

a <- affinity(s)
image(a)
}
\references{
Charu C. Aggarwal, Cecilia Procopiuc, and Philip S. Yu (2002)
Finding localized associations in market basket data, \emph{IEEE Trans. on
Knowledge and Data Engineering,} 14(1):51--62.
}
\seealso{
Other proximity classes and functions: 
\code{\link{dissimilarity}()},
\code{\link{predict}()},
\code{\link{proximity-classes}}
}
\author{
Michael Hahsler
}
\concept{proximity classes and functions}
\keyword{cluster}
\keyword{models}
