\name{mrqap.custom.null}
\alias{mrqap.custom.null}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
MRQAP function with custom permutation networks
}
\description{
Calculate MRQAP with random networks provides (i.e. generated by a custom model of user's choice)
}
\usage{
mrqap.custom.null(formula, random.y, intercept = TRUE, directed = "undirected",
	diagonal = FALSE, test.statistic = "t-value", 
	tol = 1e-07)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{formula}{
input formula (e.g. y ~ x1 + x2), where y and each x are NxN matrices
}
  \item{random.y}{
a k x N x N matrix containing a set of random networks generated by some permutation method
}
  \item{intercept}{
calculate intercept (TRUE or FALSE value)
}
  \item{directed}{
whether the network is directed or undirected (enter either "directed" or "undirected")
}
  \item{diagonal}{
whether to include self-loop values (TRUE or FALSE)
}
  \item{test.statistic}{
what to calculate P-value, either t-statistic ("t-value") or regression coefficient ("beta")
}
  \item{tol}{
tolerance value for the qr function
}
}
\details{
Calculate the regression coefficient for each input matrix using MRQAP but where the random networks are provided. This is in contrast to mrqap.dsp which has a built-in node permutation (which I have shown has higher rates of type II errors - see Farine & Whitehead 2015 and Farine in prep.). This method can easily be interfaced with the network_permutation method. Note however that this method tests whether y is related to x1 and x2 together because the different fixed effects are not permuted independently (as suggested by Dekker et al 2007). Whilst the potential to avoid type II errors may warrant this approach, further theoretical testing is needed to confirm this approach is appropriate.
}
\value{
Returns a mrqap.dsp object containing the regression coefficient and P-values for each indendent matrix (x) and associated statistics
}
\references{
Dekker, D., Krackhard, D., Snijders, T.A.B (2007) Sensitivity of MRQAP tests to collinearity and autocorellation conditions. \emph{Psychometrika} 72(4): 563-581.
Farine, D. R., & Whitehead, H. (2015) Constructing, conducting, and interpreting animal social network analysis. Journal of Animal Ecology, 84(5), 1144-1163.
Farine, D. R. (in prep) Why and how to use null models in animal social network analysis.
}
\author{
Damien R. Farine
}

\examples{

library(asnipe)
data("individuals")
data("group_by_individual")

# Generate network
network <- get_network(gbi)

# Create a species similarity matrix
species <- array(0,dim(network))

# Create a sex similarity matrix
sex <- array(0,dim(network))

# Fill each matrix with 1 (same) or 0 (different)
for (i in 1:nrow(network)) {
	species[i,-i] <- as.numeric(inds$SPECIES[i] == inds$SPECIES[-i])
	sex[i,-i] <- as.numeric(inds$SEX[i] == inds$SEX[-i])
}

# Perform network randomisation
# Note randomisations are limited to 10 to reduce runtime
networks_rand <- network_permutation(gbi, association_matrix=network, permutations=10)

# Run mrqap.custom.null
# Note randomisations are limited to 10 to reduce runtime
reg <- mrqap.custom.null(network ~ species + sex, random.y=networks_rand)

# Look at results
reg

}
